import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FurnitureIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.99996 1.71423C12.4797 1.71423 13.0573 4.59337 12.6538 7.21678C11.7406 7.53664 11.0857 8.4061 11.0857 9.42852V9.84775C10.16 9.58366 9.07998 9.37138 7.99996 9.37138C6.91995 9.37138 5.83994 9.58366 4.91425 9.84775V9.42852C4.91425 8.4061 4.25932 7.53664 3.34611 7.21678C2.94262 4.59337 3.52025 1.71423 7.99996 1.71423Z"
            fill={props.fill}
        />
        <path
            d="M8.01683 10.2857C6.68133 10.2857 5.34238 10.5216 3.99996 10.9935V9.42852C3.99996 8.63954 3.36037 7.99995 2.57139 7.99995C1.78242 7.99995 1.14282 8.63954 1.14282 9.42852C1.14282 10.1635 1.69788 10.7689 2.41168 10.8483L2.85711 14.8571H3.99996L3.99996 13.274C5.33277 13.4151 6.66558 13.4857 7.9984 13.4857C9.33162 13.4857 10.6655 13.4151 12 13.2739V14.8571H13.1428L13.5882 10.8483C14.3021 10.7689 14.8571 10.1635 14.8571 9.42852C14.8571 8.63954 14.2175 7.99995 13.4285 7.99995C12.6396 7.99995 12 8.63954 12 9.42852C12 9.44771 12.0003 9.46681 12.0011 9.48581L12 10.9778C10.6652 10.5164 9.33747 10.2857 8.01683 10.2857Z"
            fill={props.fill}
        />
    </svg>
);

FurnitureIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FurnitureIcon;
