import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GeolocationOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.44377 7.42238L8.09505 7.90364L8.52381 11.1394V12.4983L8.89043 11.1394L12.2811 3.98709L13.0599 2.97645L12.0335 3.73946L5.15589 6.98575L3.74975 7.42326L5.44377 7.42238ZM1.5701 8.34027C0.904212 8.21427 0.787836 7.30775 1.40122 7.01813L13.9979 1.0698C14.5929 0.788925 15.2098 1.40756 14.9298 2.00169L8.97969 14.5992C8.69093 15.2117 7.7853 15.0962 7.66017 14.4295L6.73878 9.26165L1.5701 8.34027L1.57097 8.33939H1.56922L1.5701 8.34027Z"
            fill={props.fill}
        />
    </svg>
);

GeolocationOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default GeolocationOutlineIcon;
