import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GiftOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 1.71181C8.61596 0.875367 9.6459 0 11.2143 0C11.9022 0 12.5897 0.228034 13.1202 0.673635C13.6558 1.12359 14 1.7751 14 2.5C14 2.68474 13.9776 2.86471 13.9355 3.0378C15.1086 3.24385 16 4.26782 16 5.5C16 6.70948 15.1411 7.71836 14 7.94999V14C14 14.5523 13.5523 15 13 15H3C2.44772 15 2 14.5523 2 14V7.94999C0.85888 7.71836 0 6.70948 0 5.5C0 4.26783 0.891415 3.24385 2.06453 3.03779C2.02235 2.86471 2 2.68474 2 2.5C2 1.7751 2.34417 1.12359 2.87983 0.673635C3.41031 0.228034 4.0978 0 4.78571 0C6.3541 0 7.38404 0.875367 8 1.71181ZM6.46193 3C6.07189 2.42382 5.54503 2 4.78571 2C4.52642 2 4.30551 2.08804 4.16622 2.20504C4.0321 2.3177 4 2.42925 4 2.5C4 2.57075 4.0321 2.6823 4.16622 2.79496C4.30551 2.91196 4.52642 3 4.78571 3H6.46193ZM4.78571 5H2.5C2.22386 5 2 5.22386 2 5.5C2 5.77614 2.22386 6 2.5 6H3H13H13.5C13.7761 6 14 5.77614 14 5.5C14 5.22386 13.7761 5 13.5 5H11.2143H8H4.78571ZM11.8338 2.79496C11.6945 2.91196 11.4736 3 11.2143 3H9.53807C9.92811 2.42382 10.455 2 11.2143 2C11.4736 2 11.6945 2.08804 11.8338 2.20504C11.9679 2.3177 12 2.42925 12 2.5C12 2.57075 11.9679 2.6823 11.8338 2.79496ZM12 8V13H4V8H12Z"
            fill={props.fill}
        />
    </svg>
);

GiftOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default GiftOutlineIcon;
