import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GlovesIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M10.921 13.1488C10.924 13.9486 10.921 14.9512 10.921 14.9512C10.921 14.9512 9.89101 15.4754 7.75972 15.4754C5.56071 15.4754 4.22617 14.9512 4.22617 14.9512C4.22617 12.6338 3.96868 12.3763 3.46794 11.3775C2.76301 9.97135 1.71263 7.75233 1.71263 7.75233C1.45958 7.34175 1.61759 6.79285 2.07404 6.563C2.5078 6.37891 2.89701 6.51488 3.24169 6.97091L4.13828 8.27081C4.45984 8.65835 4.80196 8.42883 4.80068 8.08606C4.82125 7.46901 4.79685 7.05776 4.81699 6.32645C4.83713 5.59514 4.57301 2.2139 4.57301 2.2139C4.54861 1.80264 4.913 1.4131 5.32449 1.38904C5.73597 1.36499 6.14873 1.6837 6.15044 2.14072L6.41754 6.32176C6.41797 6.43602 6.4869 6.52722 6.60123 6.52689L6.71555 6.52655C6.87569 6.54894 6.98959 6.43435 6.98917 6.32009L7.19908 1.29215C7.24319 0.85784 7.56219 0.559837 8.01949 0.558498C8.43097 0.534442 8.75253 0.921975 8.73112 1.31051L8.52206 6.56697C8.49979 6.72699 8.61454 6.84091 8.72887 6.84058C8.84319 6.84025 9.00291 6.74837 9.00248 6.63412L9.67182 2.17612C9.71593 1.74181 10.172 1.3977 10.5839 1.4879C10.9958 1.5781 11.2715 1.94292 11.2274 2.37722L10.5808 6.78945C10.5812 6.90371 10.6732 7.0634 10.7876 7.06307C10.8792 7.1085 10.9931 6.99391 11.0385 6.90237L11.8033 3.51811C11.8932 3.10652 12.3038 2.85395 12.7158 2.94415C13.1735 3.05707 13.4265 3.46766 13.3366 3.87925C13.3366 3.87925 12.368 7.78969 11.9398 9.4591C11.6696 10.5796 10.9167 12.0062 10.921 13.1488Z"
            fill={props.fill}
        />
    </svg>
);

GlovesIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default GlovesIcon;
