import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HandLuggageIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#728cf3c1__clip0_3763_7)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.9 4.34097H4.1V13.9999H11.9V4.34097ZM13.1 13.9999C14.7561 13.999 16.0983 12.6562 16.0983 10.9999L16.0983 7.34098C16.0983 5.6847 14.7561 4.34191 13.1 4.34097V13.9999ZM6.12786e-06 7.34096C9.8693e-06 5.71758 1.28944 4.39536 2.9 4.34261V13.9983C1.28943 13.9456 -6.04645e-06 12.6233 -2.305e-06 10.9999L6.12786e-06 7.34096Z"
                fill={props.fill}
            />
            <path
                d="M5.21565 3.42324L5.2085 3.52993H5.31543H5.91775H6.0093L6.01736 3.43873C6.10304 2.46921 6.94711 1.69267 7.96563 1.69267C8.98385 1.69267 9.82899 2.46917 9.9291 3.44018L9.93836 3.52993H10.0286H10.6309H10.739L10.7306 3.42213C10.6211 2.02111 9.41757 0.9 7.96563 0.9C6.51394 0.9 5.30961 2.0211 5.21565 3.42324Z"
                fill={props.fill}
                stroke={props.fill}
                strokeWidth={0.2}
            />
        </g>
        <defs>
            <clipPath id="728cf3c1__clip0_3763_7">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HandLuggageIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HandLuggageIcon;
