import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.66656 6.15466C2.31352 6.33621 2.00778 6.60151 1.77753 6.9298C1.46941 7.36911 1.31338 7.89712 1.33323 8.43334V14.6667H3.33323L3.99989 13.3333H11.9999L12.6666 14.6667H14.6666V8.43334C14.6864 7.89712 14.5304 7.36911 14.2223 6.9298C13.992 6.60151 13.6863 6.33621 13.3332 6.15466V5.83334C13.3332 4.43552 13.3332 3.73661 13.1049 3.18529C12.8004 2.45021 12.2164 1.86619 11.4813 1.5617C10.93 1.33334 10.2311 1.33334 8.83323 1.33334H7.16656C5.76874 1.33334 5.06982 1.33334 4.51851 1.5617C3.78343 1.86619 3.1994 2.45021 2.89492 3.18529C2.66656 3.73661 2.66656 4.43552 2.66656 5.83334V6.15466ZM10.9999 5.55714C9.01393 5.22311 6.98586 5.22311 4.99989 5.55714V3.84001C4.99859 3.77676 5.01036 3.71391 5.03444 3.65541C5.05853 3.59691 5.09443 3.54401 5.13989 3.50001C5.23032 3.41528 5.34931 3.36768 5.47323 3.36668H5.57323C6.37162 3.53842 7.18371 3.63882 7.99989 3.66668C8.81588 3.64101 9.62796 3.54285 10.4266 3.37334H10.5266C10.6505 3.37435 10.7695 3.42195 10.8599 3.50668C10.9054 3.55068 10.9413 3.60358 10.9653 3.66208C10.9894 3.72058 11.0012 3.78342 10.9999 3.84668V5.55714ZM2.66656 8.43334V9.33334H13.3332V8.43334C13.3395 8.19493 13.2708 7.96056 13.1368 7.76323C13.0029 7.5659 12.8104 7.41555 12.5866 7.33334C9.58833 6.47989 6.41145 6.47989 3.41323 7.33334C3.18935 7.41555 2.99689 7.5659 2.86294 7.76323C2.729 7.96056 2.66031 8.19493 2.66656 8.43334Z"
            fill={props.fill}
        />
    </svg>
);

HotelIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HotelIcon;
