import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelStarRatingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#3084e276__clip0_30514_5121)">
            <path
                d="M7.98393 13.1323L11.6199 15.0283C12.5899 15.5343 13.5239 14.8623 13.3399 13.7883L12.6459 9.77225C12.6519 9.81225 12.6659 9.77625 12.6339 9.80425L15.5799 6.96026C16.3639 6.20026 16.0059 5.11026 14.9199 4.95426L10.8599 4.36626C10.8999 4.37226 10.8699 4.35026 10.8859 4.38626L9.05993 0.730256C8.57993 -0.243744 7.41993 -0.243744 6.93993 0.730256L5.11993 4.38626C5.13993 4.35026 5.10593 4.37226 5.14593 4.36626L1.07993 4.95426C-0.00407135 5.11026 -0.360071 6.20026 0.419929 6.95826L3.36793 9.80025C3.33793 9.77225 3.34793 9.80825 3.35793 9.76825L2.66193 13.7883C2.47793 14.8563 3.41193 15.5283 4.38193 15.0283L8.01793 13.1283C7.98393 13.1483 8.02193 13.1483 7.98593 13.1283L7.98393 13.1323Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="3084e276__clip0_30514_5121">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HotelStarRatingIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HotelStarRatingIcon;
