import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const InNewTabIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M14 9.5028C14.5523 9.5028 15 9.95051 15 10.5028V13.5028C15 14.3313 14.3284 15.0028 13.5 15.0028H2.5C1.67157 15.0028 1 14.3313 1 13.5028V2.5028C1 1.67437 1.67157 1.0028 2.5 1.0028H5.5C6.05228 1.0028 6.5 1.45051 6.5 2.0028C6.5 2.55508 6.05228 3.0028 5.5 3.0028H3V13.0028H13V10.5028C13 9.95051 13.4477 9.5028 14 9.5028ZM12.3 2.78694V2.46357L11.1503 2.77787C10.6125 2.92489 10.0575 2.99938 9.5 2.99938C8.9 2.99938 8.5 2.55166 8.5 1.99829C8.5 1.446 8.94772 0.998291 9.5 0.998291H14C14.5523 0.998291 15 1.446 15 1.99829V6.5028C15 7.05508 14.5523 7.5028 14 7.5028C13.4477 7.5028 13 7.10006 13 6.5028C13 5.94348 13.0747 5.38666 13.222 4.8471L13.5353 3.70006H13.2144L12.1366 5.13695C11.8524 5.51593 11.5415 5.87423 11.2065 6.20915L7.70697 9.70731C7.31637 10.0978 6.6832 10.0977 6.29276 9.70703C5.90231 9.31643 5.90243 8.68326 6.29303 8.29282L9.79386 4.79335C10.1265 4.46088 10.4821 4.15229 10.8581 3.86987L12.3 2.78694Z"
            fill={props.fill}
        />
    </svg>
);

InNewTabIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default InNewTabIcon;
