import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const InternetAndTelephonyIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.42859 0.571429C3.42859 0.255838 3.68443 0 4.00002 0C4.31561 0 4.57145 0.255837 4.57145 0.571429V2.04938C5.44973 1.89213 6.72485 1.71429 7.99999 1.71429C9.79722 1.71429 11.5945 2.06757 12.2806 2.21857C12.4523 2.25638 12.5714 2.4091 12.5714 2.58498V11.4286C12.5714 13.9533 10.5247 16 8.00002 16C5.47529 16 3.42859 13.9533 3.42859 11.4286V0.571429ZM5.1927 4.2496C5.14287 4.34739 5.14287 4.4754 5.14287 4.73143V7.84C5.14287 8.09602 5.14287 8.22404 5.1927 8.32183C5.23653 8.40784 5.30646 8.47778 5.39248 8.5216C5.49027 8.57143 5.61828 8.57143 5.8743 8.57143H10.1257C10.3818 8.57143 10.5098 8.57143 10.6076 8.5216C10.6936 8.47778 10.7635 8.40784 10.8073 8.32183C10.8572 8.22404 10.8572 8.09602 10.8572 7.84V4.73143C10.8572 4.4754 10.8572 4.34739 10.8073 4.2496C10.7635 4.16359 10.6936 4.09365 10.6076 4.04983C10.5098 4 10.3818 4 10.1257 4H5.8743C5.61828 4 5.49027 4 5.39248 4.04983C5.30646 4.09365 5.23653 4.16359 5.1927 4.2496Z"
            fill={props.fill}
        />
    </svg>
);

InternetAndTelephonyIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default InternetAndTelephonyIcon;
