import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LikeFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.664 0.186029C10 0.118029 10.926 1.64603 10.926 2.93803C10.926 3.79903 10.867 4.98703 10.75 6.50003H13.919C15.267 6.50003 15.924 7.07403 15.924 8.36603C15.924 8.89803 15.762 9.48203 15.439 10.118C15.448 10.213 15.455 10.348 15.461 10.52C15.478 11.012 15.607 11.582 15.278 12.24C14.927 12.944 14.388 13.276 14.09 13.677C14.0328 13.7556 13.9636 13.8248 13.885 13.882C13.8778 14.0321 13.8516 14.1806 13.807 14.324C13.578 14.954 13.052 16 11.504 16H8.441C5.642 16 4.996 15.354 5 13.417V8.00003C6.84 6.89603 7.318 5.07403 7.65 3.35003C8.062 1.21103 7.668 0.236029 8.664 0.186029ZM2 8.00003H3C3.26522 8.00003 3.51957 8.10539 3.70711 8.29292C3.89464 8.48046 4 8.73481 4 9.00003V15C4 15.2652 3.89464 15.5196 3.70711 15.7071C3.51957 15.8947 3.26522 16 3 16H2C1.73478 16 1.48043 15.8947 1.29289 15.7071C1.10536 15.5196 1 15.2652 1 15V9.00003C1 8.73481 1.10536 8.48046 1.29289 8.29292C1.48043 8.10539 1.73478 8.00003 2 8.00003Z"
            fill={props.fill}
        />
    </svg>
);

LikeFilledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default LikeFilledIcon;
