import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LocationOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.02371 14.7499L9.05554 14.7159C9.52181 14.2243 10.1989 13.745 11.0975 13.2784C13.4102 12.1354 15 9.75322 15 6.9996C15 3.13405 11.8657 0 8.00001 0C4.13425 0 1 3.13316 1 6.99871C1 9.75233 2.59076 12.1344 4.90251 13.2784C5.80075 13.7449 6.47692 14.224 6.94251 14.7154L6.97455 14.7496C7.16862 14.9591 7.32458 15.1709 7.4433 15.3848L7.44509 15.388C7.50937 15.5042 7.56267 15.6212 7.60512 15.7387C7.66139 15.8956 7.83562 16 8.00001 16C8.1644 16 8.33635 15.8956 8.39261 15.7387C8.43508 15.6211 8.48843 15.5042 8.5528 15.3879L8.55458 15.3847C8.67339 15.1709 8.82949 14.9593 9.02371 14.7499ZM10.2207 11.4696L10.2061 11.4769L10.1916 11.4845C9.3684 11.9137 8.60729 12.4105 7.9994 13C7.39245 12.4108 6.63221 11.914 5.80847 11.4845L5.7943 11.4771L5.77999 11.47C4.11928 10.6449 3 8.9404 3 6.99296C3 4.26026 5.21401 2 8.00001 2C10.7857 2 13 4.26084 13 6.9938C13 8.94162 11.8813 10.6456 10.2207 11.4696Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.00118 8.63178C7.16009 8.63178 6.47192 7.93273 6.47192 7.07834C6.47192 6.22395 7.16009 5.5249 8.00118 5.5249C8.84227 5.5249 9.53043 6.22395 9.53043 7.07834C9.53043 7.93273 8.84227 8.63178 8.00118 8.63178Z"
            fill={props.fill}
        />
    </svg>
);

LocationOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default LocationOutlineIcon;
