import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LoginIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#4982a717__clip0_20742_4829)">
            <path
                d="M8.96928 7.4633L9.19794 7.23464L8.16273 6.64393C7.67849 6.3676 7.23338 6.02783 6.83916 5.63362C6.4149 5.20936 6.44864 4.60993 6.83994 4.21864C7.23046 3.82811 7.86363 3.82811 8.25415 4.21863L11.4361 7.40062C11.8267 7.79115 11.8267 8.4243 11.4361 8.81483L8.25096 12C7.86044 12.3905 7.22728 12.3905 6.83675 12C6.44621 11.6095 6.41442 11.0081 6.83675 10.5858C7.23225 10.1903 7.6788 9.84938 8.16448 9.57201L9.1971 8.98246L8.97019 8.75555L7.19203 9.00947C6.72309 9.07649 6.2499 9.11001 5.77619 9.10995L1.41406 9.109C0.861777 9.10889 0.414128 8.6611 0.414262 8.1088C0.414368 7.55652 0.862173 7.10888 1.41445 7.109L5.77843 7.10994C6.24873 7.11006 6.71838 7.1433 7.18396 7.20947L8.96928 7.4633Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5 1C5 0.447715 5.44772 0 6 0H15C15.5523 0 16 0.447715 16 1V15C16 15.5523 15.5523 16 15 16H6C5.44772 16 5 15.5523 5 15C5 14.4477 5.44772 14 6 14H14V2H6C5.44772 2 5 1.55228 5 1Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="4982a717__clip0_20742_4829">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

LoginIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default LoginIcon;
