import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MailIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M2.703 3.65005C3.704 4.19605 4.395 4.59805 4.773 4.85505L8 7.04505L11.229 4.85305C11.607 4.59805 12.298 4.19605 13.299 3.64905L12.512 3.77005C11.5057 3.92501 10.4891 4.0029 9.471 4.00305H6.529C5.51121 4.00285 4.49493 3.92496 3.489 3.77005L2.703 3.65005ZM14.148 4.72305C13.553 5.50305 13.006 6.06505 12.505 6.40405L9.123 8.70005C8.79165 8.9249 8.40043 9.0451 8 9.0451C7.59957 9.0451 7.20835 8.9249 6.877 8.70005L3.497 6.40705C2.997 6.06705 2.448 5.50605 1.852 4.72205L1.931 5.67505C1.977 6.22605 2 6.78005 2 7.33405V12.0031H14V7.33505C14 6.78005 14.023 6.22605 14.07 5.67405L14.148 4.72305ZM1.5 2.00305H14.5C14.8978 2.00305 15.2794 2.16109 15.5607 2.44239C15.842 2.7237 16 3.10523 16 3.50305V12.5031C16 12.9009 15.842 13.2824 15.5607 13.5637C15.2794 13.845 14.8978 14.0031 14.5 14.0031H1.5C1.10218 14.0031 0.720644 13.845 0.43934 13.5637C0.158035 13.2824 0 12.9009 0 12.5031L0 3.50305C0 3.10523 0.158035 2.7237 0.43934 2.44239C0.720644 2.16109 1.10218 2.00305 1.5 2.00305Z"
            fill={props.fill}
        />
    </svg>
);

MailIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MailIcon;
