import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MaleIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M6.5 4C6 4 5.5404 4.18616 5.35089 4.2624C5.12995 4.35128 5.00001 4.54205 5.00001 4.74878L5 8.03515C5 8.03515 5.00127 9.06049 5.97452 9.70227L6.10169 15.4316C6.10869 15.7472 6.41358 16 6.78728 16H7.52946L8.00002 8.20654L8.47059 16H9.21277C9.58647 16 9.89136 15.7472 9.89836 15.4316L10.0255 9.70362C11 9.06193 11 8.03515 11 8.03515V4.74848C11 4.54191 10.8703 4.35126 10.6496 4.26234C10.4601 4.18603 10 4 9.5 4C9.05239 4.47563 8.76544 4.7768 8.00012 4.7768C7.23497 4.7768 6.94761 4.47545 6.5 4Z"
            fill={props.fill}
        />
        <path
            d="M7.99994 0.0441913C7.9552 0.0441913 7.91049 0.0463715 7.86598 0.050724C7.12615 0.123063 6.58638 0.768128 6.66036 1.49152L6.77322 2.59506C6.83624 3.21128 7.36657 3.68056 7.99994 3.68056C8.63331 3.68056 9.16363 3.21128 9.22666 2.59506L9.33952 1.49152C9.34397 1.44799 9.3462 1.40428 9.3462 1.36054C9.3462 0.633539 8.74346 0.0441913 7.99994 0.0441913Z"
            fill={props.fill}
        />
    </svg>
);

MaleIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MaleIcon;
