import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MedicalTemperatureIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <circle cx={4.5} cy={12.5} r={1.5} fill={props.fill} />
        <mask id="12656f74__path-2-inside-1_10722_26" fill="white">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.5 0C3.39543 0 2.5 0.89543 2.5 2V9.62734C1.59326 10.2598 1 11.3106 1 12.5C1 14.433 2.567 16 4.5 16C6.433 16 8 14.433 8 12.5C8 11.3106 7.40674 10.2598 6.5 9.62734V2C6.5 0.895431 5.60457 0 4.5 0ZM4.5 1C3.94772 1 3.5 1.44772 3.5 2V10.208C2.61705 10.5938 2 11.4748 2 12.5C2 13.8807 3.11929 15 4.5 15C5.88071 15 7 13.8807 7 12.5C7 11.4748 6.38295 10.5938 5.5 10.208V2C5.5 1.44772 5.05228 1 4.5 1Z"
            />
        </mask>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.5 0C3.39543 0 2.5 0.89543 2.5 2V9.62734C1.59326 10.2598 1 11.3106 1 12.5C1 14.433 2.567 16 4.5 16C6.433 16 8 14.433 8 12.5C8 11.3106 7.40674 10.2598 6.5 9.62734V2C6.5 0.895431 5.60457 0 4.5 0ZM4.5 1C3.94772 1 3.5 1.44772 3.5 2V10.208C2.61705 10.5938 2 11.4748 2 12.5C2 13.8807 3.11929 15 4.5 15C5.88071 15 7 13.8807 7 12.5C7 11.4748 6.38295 10.5938 5.5 10.208V2C5.5 1.44772 5.05228 1 4.5 1Z"
            fill={props.fill}
        />
        <path
            d="M2.5 9.62734L3.0721 10.4475L3.5 10.1491V9.62734H2.5ZM6.5 9.62734H5.5V10.1491L5.9279 10.4475L6.5 9.62734ZM3.5 10.208L3.90037 11.1244L4.5 10.8624V10.208H3.5ZM5.5 10.208H4.5V10.8624L5.09963 11.1244L5.5 10.208ZM4.5 -1C2.84315 -1 1.5 0.343146 1.5 2H3.5C3.5 1.44772 3.94772 1 4.5 1V-1ZM1.5 2V9.62734H3.5V2H1.5ZM1.9279 8.80716C0.764534 9.61863 0 10.97 0 12.5H2C2 11.6513 2.42198 10.901 3.0721 10.4475L1.9279 8.80716ZM0 12.5C0 14.9853 2.01472 17 4.5 17V15C3.11929 15 2 13.8807 2 12.5H0ZM4.5 17C6.98528 17 9 14.9853 9 12.5H7C7 13.8807 5.88071 15 4.5 15V17ZM9 12.5C9 10.97 8.23547 9.61863 7.0721 8.80716L5.9279 10.4475C6.57802 10.901 7 11.6513 7 12.5H9ZM7.5 9.62734V2H5.5V9.62734H7.5ZM7.5 2C7.5 0.343146 6.15685 -1 4.5 -1V1C5.05228 1 5.5 1.44772 5.5 2H7.5ZM4.5 0C3.39543 0 2.5 0.89543 2.5 2H4.5V0ZM2.5 2V10.208H4.5V2H2.5ZM3.09963 9.29167C1.86559 9.83084 1 11.0632 1 12.5H3C3 11.8865 3.36851 11.3568 3.90037 11.1244L3.09963 9.29167ZM1 12.5C1 14.433 2.567 16 4.5 16V14C3.67157 14 3 13.3284 3 12.5H1ZM4.5 16C6.433 16 8 14.433 8 12.5H6C6 13.3284 5.32843 14 4.5 14V16ZM8 12.5C8 11.0632 7.13441 9.83084 5.90037 9.29167L5.09963 11.1244C5.63149 11.3568 6 11.8865 6 12.5H8ZM6.5 10.208V2H4.5V10.208H6.5ZM6.5 2C6.5 0.895431 5.60457 0 4.5 0V2H6.5Z"
            fill={props.fill}
            mask="url(#12656f74__path-2-inside-1_10722_26)"
        />
        <rect x={4} y={7} width={1} height={5} rx={0.5} fill={props.fill} />
        <rect x={10} y={3} width={6} height={2} fill={props.fill} />
        <rect
            x={12}
            y={7}
            width={6}
            height={2}
            transform="rotate(-90 12 7)"
            fill={props.fill}
        />
    </svg>
);

MedicalTemperatureIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MedicalTemperatureIcon;
