import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MessageOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#6796ae49__clip0_28868_5165)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M2.48072 1.11867C3.98658 0.19199 5.98765 0 8 0C10.0124 0 12.0134 0.19199 13.5193 1.11867C15.1143 2.10024 16 3.79851 16 6.4C16 8.96062 15.244 10.7501 13.7174 11.8492C12.3088 12.8635 10.1877 13.1764 8.05405 13.1987L4.25877 15.8554C4.01439 16.0264 3.69514 16.0473 3.43055 15.9096C3.16597 15.7718 3 15.4983 3 15.2V12.5573C1.58362 11.896 0 10.0361 0 6.4C0 3.79851 0.885682 2.10024 2.48072 1.11867ZM3.61182 2.82624C2.66967 3.40603 2 4.43889 2 6.5C2 9.77921 3.78792 10.8614 4.4319 11.0224C4.76578 11.1059 5 11.4058 5 11.75V13.3095L7.5699 11.5106C7.69597 11.4223 7.84612 11.375 8 11.375C10.0296 11.375 11.5127 11.0904 12.4836 10.3913C13.3963 9.73425 14 8.59942 14 6.5C14 4.43889 13.3303 3.40603 12.3882 2.82624C11.3624 2.19501 9.86342 2 8 2C6.13658 2 4.63758 2.19501 3.61182 2.82624Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="6796ae49__clip0_28868_5165">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

MessageOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MessageOutlineIcon;
