import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MiniBarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M3.65719 0.816327C3.65719 0.588335 3.65719 0.474339 3.68926 0.382698C3.7467 0.218557 3.87575 0.0895021 4.03989 0.0320667C4.13153 0 4.24553 0 4.47352 0H5.8123C6.04029 0 6.15428 0 6.24593 0.0320667C6.41007 0.0895021 6.53912 0.218557 6.59656 0.382698C6.62862 0.474339 6.62862 0.588335 6.62862 0.816327C6.62862 0.907523 6.62862 0.953122 6.6158 0.989778C6.59282 1.05543 6.5412 1.10706 6.47554 1.13003C6.43889 1.14286 6.39329 1.14286 6.30209 1.14286H3.98373C3.89253 1.14286 3.84693 1.14286 3.81027 1.13003C3.74462 1.10706 3.693 1.05543 3.67002 0.989778C3.65719 0.953122 3.65719 0.907523 3.65719 0.816327Z"
            fill={props.fill}
        />
        <path
            d="M7.21811 5.74503C6.98261 6.11275 6.8572 6.54052 6.8572 6.97777V15.7943C6.28577 15.9314 5.71434 16 5.14291 16C4.31867 16 3.49443 15.8573 2.67019 15.572C2.44008 15.4923 2.28577 15.2755 2.28577 15.032V7.78853C2.28577 7.56751 2.30291 7.36596 2.3399 7.17537C2.37689 6.98478 2.43372 6.80515 2.51309 6.62796C2.59245 6.45078 2.69435 6.27604 2.82148 6.09524L3.05371 5.76495C3.19213 5.56809 3.233 5.50497 3.27356 5.43059C3.31412 5.35622 3.34306 5.28665 3.36724 5.20545C3.39142 5.12425 3.40739 5.05077 3.44948 4.81383L4.00005 1.71429H6.28577L6.83634 4.81383C6.87843 5.05077 6.8944 5.12425 6.91858 5.20545C6.94275 5.28665 6.9717 5.35622 7.01226 5.43059C7.05142 5.50241 7.09087 5.56372 7.21811 5.74503Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.04499 7.21331C8.00005 7.45499 8.00005 7.70566 8.00005 8.207V14.8096C8.00005 15.0279 8.00005 15.137 8.04157 15.2399C8.07566 15.3244 8.14291 15.4149 8.214 15.4719C8.30055 15.5413 8.39558 15.5699 8.58563 15.6271C9.13382 15.7921 9.99551 16 10.8572 16C11.7189 16 12.5806 15.7921 13.1288 15.6271C13.3188 15.5699 13.4138 15.5413 13.5004 15.4719C13.5715 15.4149 13.6387 15.3244 13.6728 15.2399C13.7143 15.137 13.7143 15.0279 13.7143 14.8096V8.207C13.7143 7.70566 13.7143 7.45499 13.6694 7.21331C13.6295 6.99882 13.5635 6.79004 13.4727 6.59164C13.3705 6.36809 13.2263 6.16303 12.9379 5.75292L12.9154 5.72085C12.8137 5.57625 12.7629 5.50393 12.7223 5.42636C12.6863 5.35747 12.6564 5.28555 12.6329 5.21144C12.6064 5.128 12.591 5.04097 12.5601 4.86691L12.0001 1.71429H9.71434L9.15433 4.86691C9.12341 5.04097 9.10795 5.128 9.08151 5.21144C9.05802 5.28555 9.0281 5.35747 8.99208 5.42636C8.95153 5.50393 8.90069 5.57623 8.79902 5.72084L8.77646 5.75292C8.4881 6.16303 8.34392 6.36809 8.24167 6.59164C8.15093 6.79004 8.08487 6.99882 8.04499 7.21331ZM10.2858 9.14286H12.0001C12.3156 9.14286 12.5715 9.39869 12.5715 9.71429V12C12.5715 12.3156 12.3156 12.5714 12.0001 12.5714H10.2858V14.0571C10.2858 14.3727 10.0299 14.6286 9.71434 14.6286C9.39875 14.6286 9.14291 14.3727 9.14291 14.0571V7.8873C9.14291 7.21559 9.34174 6.5589 9.71434 6L10.1273 5.38059C10.2306 5.22557 10.2858 5.04344 10.2858 4.85714C10.2858 4.69935 10.4137 4.57143 10.5715 4.57143C10.7293 4.57143 10.8572 4.69935 10.8572 4.85714V5.14286C10.8572 5.51865 10.7697 5.88927 10.6016 6.22539L10.5715 6.28571C10.3836 6.6615 10.2858 7.07588 10.2858 7.49602V9.14286Z"
            fill={props.fill}
        />
        <path
            d="M9.40355 0.382698C9.37148 0.474339 9.37148 0.588335 9.37148 0.816327C9.37148 0.907523 9.37148 0.953122 9.38431 0.989778C9.40728 1.05543 9.4589 1.10706 9.52456 1.13003C9.56122 1.14286 9.60682 1.14286 9.69801 1.14286H12.0164C12.1076 1.14286 12.1532 1.14286 12.1898 1.13003C12.2555 1.10706 12.3071 1.05543 12.3301 0.989778C12.3429 0.953122 12.3429 0.907523 12.3429 0.816327C12.3429 0.588335 12.3429 0.474339 12.3108 0.382698C12.2534 0.218557 12.1244 0.0895021 11.9602 0.0320667C11.8686 0 11.7546 0 11.5266 0H10.1878C9.95982 0 9.84582 0 9.75418 0.0320667C9.59004 0.0895021 9.46098 0.218557 9.40355 0.382698Z"
            fill={props.fill}
        />
    </svg>
);

MiniBarIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MiniBarIcon;
