import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MinusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <rect y={7} width={16} height={2} rx={1} fill={props.fill} />
    </svg>
);

MinusIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MinusIcon;
