import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MultimediaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.7 0.3C11.3 -0.0999999 10.7 -0.0999999 10.3 0.3L8 2.6L5.7 0.3C5.3 -0.0999999 4.7 -0.0999999 4.3 0.3C3.9 0.7 3.9 1.3 4.3 1.7L5.6 3H2.75C1.7875 3 1 3.83077 1 4.84615V13.1538C1 14.1692 1.7875 15 2.75 15H13.25C14.2125 15 15 14.1692 15 13.1538V4.84615C15 3.83077 14.2125 3 13.25 3H10.4L11.7 1.7C12.1 1.3 12.1 0.7 11.7 0.3ZM13 13V5H3V13H13Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7 7.5L9 9L7 10.5V7.5Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

MultimediaIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MultimediaIcon;
