import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NewspaperIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.42854 14.8571H14.8571C13.5947 14.8571 12.5714 13.8338 12.5714 12.5714V2.85713C12.5714 2.54154 12.3156 2.28571 12 2.28571H1.71425C1.39866 2.28571 1.14282 2.54154 1.14282 2.85713V12.5714C1.14282 13.8338 2.16617 14.8571 3.42854 14.8571ZM3.45345 4.69622C3.42854 4.74512 3.42854 4.80912 3.42854 4.93713V6.49142C3.42854 6.61943 3.42854 6.68344 3.45345 6.73233C3.47536 6.77534 3.51033 6.81031 3.55334 6.83222C3.60223 6.85713 3.66624 6.85713 3.79425 6.85713H9.91996C10.048 6.85713 10.112 6.85713 10.1609 6.83222C10.2039 6.81031 10.2389 6.77534 10.2608 6.73233C10.2857 6.68344 10.2857 6.61943 10.2857 6.49142V4.93713C10.2857 4.80912 10.2857 4.74512 10.2608 4.69622C10.2389 4.65321 10.2039 4.61825 10.1609 4.59633C10.112 4.57142 10.048 4.57142 9.91996 4.57142H3.79425C3.66624 4.57142 3.60223 4.57142 3.55334 4.59633C3.51033 4.61825 3.47536 4.65321 3.45345 4.69622ZM7.99996 9.50856C7.99996 9.38055 7.99996 9.31654 8.02488 9.26765C8.04679 9.22464 8.08176 9.18967 8.12477 9.16776C8.17366 9.14285 8.23767 9.14285 8.36568 9.14285H9.91996C10.048 9.14285 10.112 9.14285 10.1609 9.16776C10.2039 9.18967 10.2389 9.22464 10.2608 9.26765C10.2857 9.31654 10.2857 9.38055 10.2857 9.50856V9.91999C10.2857 10.048 10.2857 10.112 10.2608 10.1609C10.2389 10.2039 10.2039 10.2389 10.1609 10.2608C10.112 10.2857 10.048 10.2857 9.91996 10.2857H8.36568C8.23767 10.2857 8.17366 10.2857 8.12477 10.2608C8.08176 10.2389 8.04679 10.2039 8.02488 10.1609C7.99996 10.112 7.99996 10.048 7.99996 9.91999V9.50856ZM8.02488 11.5534C7.99996 11.6023 7.99996 11.6663 7.99996 11.7943V12.2057C7.99996 12.3337 7.99996 12.3977 8.02488 12.4466C8.04679 12.4896 8.08176 12.5246 8.12477 12.5465C8.17366 12.5714 8.23767 12.5714 8.36568 12.5714H9.91996C10.048 12.5714 10.112 12.5714 10.1609 12.5465C10.2039 12.5246 10.2389 12.4896 10.2608 12.4466C10.2857 12.3977 10.2857 12.3337 10.2857 12.2057V11.7943C10.2857 11.6663 10.2857 11.6023 10.2608 11.5534C10.2389 11.5104 10.2039 11.4754 10.1609 11.4535C10.112 11.4286 10.048 11.4286 9.91996 11.4286H8.36568C8.23767 11.4286 8.17366 11.4286 8.12477 11.4535C8.08176 11.4754 8.04679 11.5104 8.02488 11.5534ZM3.45345 9.26765C3.42854 9.31654 3.42854 9.38055 3.42854 9.50856V12.2057C3.42854 12.3337 3.42854 12.3977 3.45345 12.4466C3.47536 12.4896 3.51033 12.5246 3.55334 12.5465C3.60223 12.5714 3.66624 12.5714 3.79425 12.5714H5.34854C5.47655 12.5714 5.54055 12.5714 5.58945 12.5465C5.63246 12.5246 5.66742 12.4896 5.68934 12.4466C5.71425 12.3977 5.71425 12.3337 5.71425 12.2057V9.50856C5.71425 9.38055 5.71425 9.31654 5.68934 9.26765C5.66742 9.22464 5.63246 9.18967 5.58945 9.16776C5.54055 9.14285 5.47655 9.14285 5.34854 9.14285H3.79425C3.66624 9.14285 3.60223 9.14285 3.55334 9.16776C3.51033 9.18967 3.47536 9.22464 3.45345 9.26765Z"
            fill={props.fill}
        />
        <path
            d="M13.7143 6.85713H15.0857C15.4057 6.85713 15.5657 6.85713 15.688 6.91942C15.7955 6.9742 15.8829 7.06162 15.9377 7.16914C16 7.29137 16 7.45139 16 7.77142V12.5714C16 13.2026 15.4883 13.7143 14.8571 13.7143C14.2259 13.7143 13.7143 13.2026 13.7143 12.5714V6.85713Z"
            fill={props.fill}
        />
    </svg>
);

NewspaperIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default NewspaperIcon;
