import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NightConnectionIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.9515 11.706C13.7125 13.6866 11.5146 15 9.00841 15C5.13977 15 2 11.8602 2 7.99159C2 4.28274 4.88186 1.2467 8.52763 1C7.11193 2.15639 6.20505 3.9155 6.20505 5.88907C6.20505 9.37225 9.02943 12.1966 12.5126 12.1966C13.3775 12.1966 14.2016 12.0228 14.9515 11.706Z"
            fill={props.fill}
        />
    </svg>
);

NightConnectionIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default NightConnectionIcon;
