import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoMealsIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.00033 7.00138V0.703641C6.00033 0.514257 5.91978 0.33381 5.7788 0.207355C5.50471 -0.0384954 5.08321 -0.0156018 4.83736 0.258489L4.83737 0.258497C3.99682 1.1956 3.40041 2.45918 3.04816 4.04921L6.00033 7.00138ZM6.00033 8.41559L2.83654 5.25181C2.72351 6.0923 2.66699 7.00837 2.66699 8C3.55588 8.19609 4.13366 8.64053 4.40033 9.33334L4.18912 14.6134C4.18841 14.6311 4.18806 14.6489 4.18806 14.6667C4.18806 15.4031 4.78501 16 5.52139 16H6.00033V8.41559Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.5001 6.66667C12.8045 8 11.8045 8.66667 10.5001 8.66667C9.19577 8.66667 8.19577 8 7.50012 6.66667L7.74535 0.399681C7.75409 0.176405 7.9337 0 8.1523 0L8.41952 0C8.48903 0 8.54633 0.0557137 8.5498 0.126675L8.77186 4.66667H9.88056L10.1026 0.126675C10.1061 0.0557137 10.1634 0 10.2329 0L10.7674 0C10.8369 0 10.8942 0.0557137 10.8976 0.126675L11.1197 4.66667H12.2284L12.4504 0.126675C12.4539 0.0557137 12.5112 0 12.5807 0L12.8479 0C13.0665 0 13.2462 0.176405 13.2549 0.399681L13.5001 6.66667Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.69531 12.1096L9.60573 15.3143L9.60547 15.3333C9.60547 15.7015 9.89746 16 10.2576 16H10.7416L10.7602 15.9997C11.1202 15.9892 11.4038 15.6823 11.3935 15.3143L11.3502 13.7645L9.69531 12.1096ZM11.3095 12.3096L11.2236 9.23627C10.9823 9.30098 10.7409 9.33334 10.4996 9.33334C10.2583 9.33334 10.0169 9.30098 9.77562 9.23627L9.73376 10.7338L11.3095 12.3096Z"
            fill={props.fill}
        />
        <path
            d="M1.06051 1.35355C1.25577 1.15829 1.57235 1.15829 1.76762 1.35355L15.2026 14.7886C15.3979 14.9838 15.3979 15.3004 15.2026 15.4957C15.0074 15.691 14.6908 15.691 14.4955 15.4957L1.06051 2.06066C0.865247 1.8654 0.865247 1.54882 1.06051 1.35355Z"
            fill={props.fill}
        />
    </svg>
);

NoMealsIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default NoMealsIcon;
