import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoTicketReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#984c2628__clip0_21667_4751)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.65585 14.5944C6.405 14.8612 7.19763 14.9996 8.00012 15C9.85664 15 11.6371 14.2625 12.9499 12.9497C14.2626 11.637 15.0001 9.85652 15.0001 8C15.0001 6.82462 14.7045 5.67973 14.1545 4.6647L12.7177 6.34339C12.9029 6.87079 13.0001 7.43038 13.0001 8C13.0001 9.32608 12.4733 10.5979 11.5357 11.5355C10.598 12.4732 9.3262 13 8.00012 13C7.68947 13 7.3859 12.9714 7.09171 12.9167L5.65585 14.5944ZM4.23776 13.9L5.55941 12.3558C4.6959 11.8642 3.99347 11.1204 3.54512 10.227L1.74412 11.128C2.3095 12.2611 3.17159 13.219 4.23776 13.9ZM11.9316 4.91067L13.2502 3.37C13.1537 3.26063 13.0536 3.15398 12.9499 3.05025C11.6371 1.7375 9.85664 1 8.00012 1C6.21154 0.998768 4.49116 1.68634 3.19612 2.92L1.09912 1L-0.00187874 8.127L7.00012 6.402L4.68412 4.282C5.59205 3.45795 6.77399 3.001 8.00012 3C9.3262 3 10.598 3.52679 11.5357 4.46447C11.6771 4.60592 11.8092 4.75497 11.9316 4.91067Z"
                fill={props.fill}
            />
            <path
                d="M1.297 15.1099C1.29491 14.8748 1.38714 14.6317 1.55382 14.4329L13.4494 0.659295C13.622 0.465256 13.8531 0.333937 14.093 0.29362C14.333 0.253304 14.5625 0.307216 14.7321 0.443746C14.9018 0.580275 14.998 0.788498 15.0001 1.02357C15.0022 1.25864 14.9099 1.50174 14.7433 1.70053L2.8477 15.4741C2.67512 15.6682 2.44397 15.7995 2.20405 15.8398C1.96413 15.8801 1.73463 15.8262 1.56497 15.6897C1.39531 15.5532 1.29908 15.3449 1.297 15.1099Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="984c2628__clip0_21667_4751">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

NoTicketReturnIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default NoTicketReturnIcon;
