import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const OnlineRegistrationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M4.05518 3.74032C3.63919 3.74032 3.22753 3.82005 2.8202 3.9795C2.79716 3.98788 2.77415 3.99636 2.75117 4.00495C2.15309 4.22857 1.45091 3.9473 1.26778 3.3356L1.22824 3.20352C1.09475 2.75766 1.28375 2.2709 1.7126 2.09006C1.95404 1.98825 2.20191 1.90053 2.45621 1.82689C2.96753 1.66744 3.51352 1.58771 4.09418 1.58771C5.46349 1.58771 6.52515 2.1401 7.27913 3.24488C8.03312 4.33827 8.41012 5.88154 8.41012 7.8747C8.41012 9.12754 8.24979 10.2266 7.92912 11.172C7.60846 12.1059 7.11447 12.8348 6.44715 13.3587C5.78849 13.8713 4.9435 14.1275 3.91218 14.1275C3.38353 14.1275 2.90253 14.0763 2.46921 13.9738C2.22911 13.9158 1.98623 13.8396 1.74059 13.7453C1.38421 13.6084 1.16923 13.2534 1.16923 12.8716V12.773C1.16923 12.084 1.86968 11.6221 2.53421 11.8041C2.95887 11.918 3.37919 11.9749 3.79519 11.9749C4.59251 11.9749 5.20783 11.7186 5.64116 11.2061C6.07449 10.6822 6.30848 9.90203 6.34315 8.86559H3.31319C2.76092 8.86559 2.31321 8.41788 2.31321 7.8656V7.74713C2.31321 7.19485 2.76092 6.74714 3.31319 6.74714H6.33015C6.30415 5.80182 6.08748 5.0672 5.68016 4.54328C5.27283 4.00798 4.73117 3.74032 4.05518 3.74032Z"
            fill={props.fill}
        />
        <path
            d="M12.5551 1.75856C13.751 1.75856 14.622 2.10024 15.168 2.78361C15.7227 3.45559 16 4.38383 16 5.56833C16 6.27448 15.8873 6.94077 15.662 7.56719C15.4367 8.18222 15.0597 8.67766 14.531 9.05351C14.011 9.42937 13.3004 9.61729 12.3991 9.61729H11.5541V12.9752C11.5541 13.5173 11.1146 13.9567 10.5726 13.9567C10.0305 13.9567 9.5911 13.5173 9.5911 12.9752V2.75854C9.5911 2.20626 10.0388 1.75856 10.5911 1.75856H12.5551ZM12.4511 3.877H11.5541V7.49885H12.2041C12.7587 7.49885 13.1964 7.35648 13.517 7.07174C13.8464 6.77562 14.011 6.30296 14.011 5.65376C14.011 4.46925 13.491 3.877 12.4511 3.877Z"
            fill={props.fill}
        />
    </svg>
);

OnlineRegistrationIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default OnlineRegistrationIcon;
