import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PaidReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.23 8.07512V3.24512H7.765C8.885 3.24512 9.755 3.49012 10.375 3.98012C11.005 4.47012 11.32 5.21012 11.32 6.20012C11.32 6.71012 11.23 7.15012 11.05 7.52012C10.88 7.89012 10.63 8.19512 10.3 8.43512C9.98 8.66512 9.595 8.84012 9.145 8.96012C8.695 9.07012 8.195 9.12512 7.645 9.12512H6.64V10.4001H9.775V11.4501H6.64V14.0001H5.23V11.4501H4V10.4001H5.23V9.12512H4V8.07512H5.23ZM6.64 4.46012V8.07512H7.645C8.375 8.07512 8.93 7.92512 9.31 7.62512C9.7 7.31512 9.895 6.84012 9.895 6.20012C9.895 5.61012 9.725 5.17512 9.385 4.89512C9.055 4.60512 8.515 4.46012 7.765 4.46012H6.64Z"
            fill={props.fill}
        />
    </svg>
);

PaidReturnIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PaidReturnIcon;
