import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ParkingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1 2.5C1 1.67157 1.67157 1 2.5 1H13.5C14.3284 1 15 1.67157 15 2.5V13.5C15 14.3284 14.3284 15 13.5 15H2.5C1.67157 15 1 14.3284 1 13.5V2.5ZM5 12H7V10H8.5C9.88071 10 11 8.88071 11 7.5V6.5C11 5.11929 9.88071 4 8.5 4H5V12ZM8.5 8H7V6H8.5C8.77614 6 9 6.22386 9 6.5V7.5C9 7.77614 8.77614 8 8.5 8Z"
            fill={props.fill}
        />
    </svg>
);

ParkingIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ParkingIcon;
