import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PatioIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.1428 6.95712C12.528 6.95712 11.9888 6.63346 11.6863 6.14724C11.5973 6.00423 11.4092 5.96044 11.2662 6.04942C11.2233 6.07612 11.1877 6.11306 11.1626 6.15692C11.1495 6.17988 11.136 6.20123 11.1223 6.22097C10.8126 6.66591 10.2974 6.95712 9.71427 6.95712C9.13177 6.95712 8.61713 6.6666 8.30734 6.22255C8.18879 6.05262 7.95493 6.01097 7.785 6.12952C7.74678 6.15619 7.71386 6.18974 7.68793 6.22846C7.68139 6.23828 7.67475 6.24775 7.66805 6.25686C7.35603 6.68151 6.85305 6.95712 6.28569 6.95712C5.73802 6.95712 5.25033 6.70029 4.93649 6.30051C4.93383 6.29712 4.93118 6.29368 4.92853 6.29019C4.77909 6.09296 4.49805 6.05426 4.30084 6.20373C4.2691 6.22778 4.24071 6.25596 4.21642 6.28752C3.903 6.69472 3.4107 6.95712 2.85712 6.95712C1.91035 6.95712 1.14284 6.18961 1.14284 5.24283C1.14284 4.91876 6.06668 3.32051 6.77151 0.4481C6.82167 0.243689 7.00501 0.0999756 7.21548 0.0999756L8.78458 0.100046C8.99505 0.100046 9.17832 0.243774 9.22848 0.448181C9.93329 3.32016 14.8571 4.91838 14.8571 5.24283C14.8571 6.18961 14.0896 6.95712 13.1428 6.95712Z"
            fill={props.fill}
        />
        <path
            d="M7.42855 6.3857C7.42855 6.07011 7.68439 5.81427 7.99998 5.81427C8.31557 5.81427 8.57141 6.07011 8.57141 6.3857V15.5286C8.57141 15.8441 8.31557 16.1 7.99998 16.1C7.68439 16.1 7.42855 15.8441 7.42855 15.5286V6.3857Z"
            fill={props.fill}
        />
        <path
            d="M3.99998 9.84998C3.99998 9.43576 4.33576 9.09998 4.74998 9.09998H11.25C11.6642 9.09998 12 9.43576 12 9.84998C12 10.2642 11.6642 10.6 11.25 10.6H4.74998C4.33576 10.6 3.99998 10.2642 3.99998 9.84998Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.499977 8.59998C0.499977 8.32383 0.723835 8.09998 0.999977 8.09998C1.27612 8.09998 1.49998 8.32383 1.49998 8.59998V11.6C1.49998 11.8761 1.72383 12.1 1.99998 12.1H3.99998C4.00905 12.1 4.01812 12.1 4.02718 12.1C4.23922 12.0999 4.44528 12.0999 4.61524 12.1227C4.80684 12.1485 5.02548 12.2113 5.20708 12.3929C5.38869 12.5745 5.45145 12.7931 5.47721 12.9847C5.50006 13.1547 5.50002 13.3607 5.49998 13.5728C5.49998 13.5818 5.49998 13.5909 5.49998 13.6V15.4349C5.49998 15.711 5.27612 15.9349 4.99998 15.9349C4.72383 15.9349 4.49998 15.711 4.49998 15.4349V13.6C4.49998 13.3501 4.49891 13.2131 4.48613 13.118C4.48583 13.1158 4.48414 13.1141 4.48199 13.1138C4.38689 13.101 2.24981 13.1 1.99998 13.1C1.72383 13.1 1.49998 13.3238 1.49998 13.6V15.4349C1.49998 15.711 1.27612 15.9349 0.999977 15.9349C0.723835 15.9349 0.499977 15.711 0.499977 15.4349V8.59998Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.349976 8.59995C0.349976 8.24097 0.64099 7.94995 0.999976 7.94995C1.35896 7.94995 1.64998 8.24097 1.64998 8.59995V11.6C1.64998 11.7933 1.80668 11.95 1.99998 11.95L4.03419 11.9499C4.24094 11.9499 4.45526 11.9499 4.63522 11.9741C4.84331 12.002 5.09896 12.0726 5.31315 12.2868C5.52734 12.501 5.5979 12.7566 5.62587 12.9647C5.65007 13.1447 5.65002 13.359 5.64998 13.5657L5.64998 15.4349C5.64998 15.7939 5.35896 16.0849 4.99998 16.0849C4.64099 16.0849 4.34998 15.7939 4.34998 15.4349V13.6C4.34998 13.4449 4.34946 13.3379 4.34654 13.2593C4.28016 13.2582 4.19178 13.2571 4.08788 13.2562C3.87067 13.2543 3.58714 13.253 3.29853 13.2521C2.72136 13.2502 2.12481 13.25 1.99998 13.25C1.80668 13.25 1.64998 13.4067 1.64998 13.6V15.4349C1.64998 15.7939 1.35896 16.0849 0.999976 16.0849C0.640991 16.0849 0.349976 15.7939 0.349976 15.4349V8.59995ZM4.63479 13.098C4.64924 13.2055 4.64998 13.3547 4.64998 13.6V15.4349C4.64998 15.6282 4.80668 15.7849 4.99998 15.7849C5.19328 15.7849 5.34998 15.6282 5.34998 15.4349L5.34998 13.5727C5.35002 13.3576 5.34978 13.1626 5.32855 13.0047C5.30501 12.8296 5.25004 12.6479 5.10102 12.4989C4.95199 12.3499 4.77036 12.2949 4.59525 12.2714C4.43734 12.2501 4.24236 12.2499 4.02721 12.2499L1.99998 12.25C1.64099 12.25 1.34998 11.9589 1.34998 11.6V8.59995C1.34998 8.40665 1.19328 8.24995 0.999976 8.24995C0.806676 8.24995 0.649976 8.40665 0.649976 8.59995V15.4349C0.649976 15.6282 0.806676 15.7849 0.999976 15.7849C1.19328 15.7849 1.34998 15.6282 1.34998 15.4349V13.6C1.34998 13.241 1.64099 12.95 1.99998 12.95C2.12498 12.95 2.72188 12.9502 3.29949 12.9521C3.58826 12.953 3.87245 12.9543 4.0905 12.9562C4.19946 12.9572 4.29229 12.9583 4.36104 12.9596C4.42332 12.9607 4.47907 12.9621 4.50198 12.9651C4.57078 12.9746 4.62535 13.0291 4.63479 13.098Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.5 8.59997C15.5 8.32383 15.2761 8.09998 15 8.09998C14.7238 8.09998 14.5 8.32383 14.5 8.59997V11.5975C14.5 11.8736 14.2761 12.0975 14 12.0975H12C11.9909 12.0975 11.9818 12.0975 11.9728 12.0975C11.7607 12.0974 11.5547 12.0974 11.3847 12.1202C11.1931 12.146 10.9745 12.2087 10.7929 12.3902C10.6113 12.5717 10.5485 12.7902 10.5227 12.9816C10.4999 13.1515 10.4999 13.3574 10.5 13.5693C10.5 13.5784 10.5 13.5874 10.5 13.5965V15.43C10.5 15.7061 10.7238 15.93 11 15.93C11.2761 15.93 11.5 15.7061 11.5 15.43V13.5965C11.5 13.3468 11.501 13.2098 11.5138 13.1148C11.5141 13.1127 11.5158 13.111 11.518 13.1107C11.6131 13.0979 13.7501 13.0968 14 13.0968C14.2761 13.0968 14.5 13.3207 14.5 13.5968V15.43C14.5 15.7061 14.7238 15.93 15 15.93C15.2761 15.93 15.5 15.7061 15.5 15.43V8.59997Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.65 8.59995C15.65 8.24097 15.359 7.94995 15 7.94995C14.641 7.94995 14.35 8.24096 14.35 8.59995V11.5974C14.35 11.7907 14.1933 11.9474 14 11.9474L11.9658 11.9474C11.759 11.9474 11.5447 11.9473 11.3647 11.9715C11.1567 11.9995 10.901 12.07 10.6868 12.284C10.4726 12.4981 10.4021 12.7536 10.3741 12.9616C10.3499 13.1415 10.3499 13.3557 10.35 13.5623L10.35 15.43C10.35 15.7889 10.641 16.08 11 16.08C11.359 16.08 11.65 15.7889 11.65 15.43V13.5965C11.65 13.4416 11.6505 13.3347 11.6534 13.2562C11.7198 13.255 11.8082 13.254 11.9121 13.2531C12.1293 13.2512 12.4128 13.2499 12.7014 13.2489C13.2786 13.2471 13.8751 13.2468 14 13.2468C14.1933 13.2468 14.35 13.4035 14.35 13.5968V15.43C14.35 15.7889 14.641 16.08 15 16.08C15.359 16.08 15.65 15.7889 15.65 15.43V8.59995ZM11.3652 13.0948C11.3507 13.2022 11.35 13.3514 11.35 13.5965V15.43C11.35 15.6233 11.1933 15.78 11 15.78C10.8067 15.78 10.65 15.6233 10.65 15.43L10.65 13.5693C10.6499 13.3543 10.6502 13.1594 10.6714 13.0016C10.695 12.8266 10.7499 12.6452 10.8989 12.4962C11.0479 12.3473 11.2296 12.2924 11.4047 12.2689C11.5626 12.2476 11.7576 12.2474 11.9727 12.2474L14 12.2474C14.359 12.2474 14.65 11.9564 14.65 11.5974V8.59995C14.65 8.40665 14.8067 8.24995 15 8.24995C15.1933 8.24995 15.35 8.40665 15.35 8.59995V15.43C15.35 15.6233 15.1933 15.78 15 15.78C14.8067 15.78 14.65 15.6233 14.65 15.43V13.5968C14.65 13.2378 14.359 12.9468 14 12.9468C13.875 12.9468 13.2781 12.9471 12.7005 12.9489C12.4117 12.9499 12.1275 12.9512 11.9095 12.9531C11.8005 12.9541 11.7077 12.9551 11.6389 12.9564C11.5766 12.9576 11.5209 12.9589 11.498 12.962C11.4293 12.9714 11.3746 13.0259 11.3652 13.0948Z"
            fill={props.fill}
        />
        <path
            d="M11.6863 6.14724L11.7712 6.09441L11.6863 6.14724ZM11.2662 6.04942L11.2134 5.96451L11.2662 6.04942ZM11.1626 6.15692L11.2494 6.20659L11.2494 6.20658L11.1626 6.15692ZM11.1223 6.22097L11.2044 6.2781L11.1223 6.22097ZM8.30734 6.22255L8.38935 6.16533L8.30734 6.22255ZM7.785 6.12952L7.84222 6.21154L7.785 6.12952ZM7.68793 6.22846L7.60484 6.17282L7.60473 6.17299L7.68793 6.22846ZM7.66805 6.25686L7.58747 6.19765L7.66805 6.25686ZM4.93649 6.30051L4.85783 6.36226L4.93649 6.30051ZM4.92853 6.29019L4.84883 6.35058L4.84884 6.35059L4.92853 6.29019ZM4.30084 6.20373L4.24044 6.12403L4.30084 6.20373ZM4.21642 6.28752L4.13718 6.22653L4.21642 6.28752ZM2.85712 6.95712V6.85712V6.95712ZM6.77151 0.4481L6.67439 0.424269L6.77151 0.4481ZM7.21548 0.0999756L7.21549 -2.44156e-05H7.21548V0.0999756ZM8.78458 0.100046L8.78457 0.200046H8.78458V0.100046ZM9.22848 0.448181L9.3256 0.424347L9.22848 0.448181ZM4.02718 12.1L4.0272 12.2H4.0272L4.02718 12.1ZM4.61524 12.1227L4.62856 12.0236L4.61524 12.1227ZM5.20708 12.3929L5.13637 12.4636V12.4636L5.20708 12.3929ZM5.47721 12.9847L5.57632 12.9714L5.47721 12.9847ZM5.49998 13.5728L5.59998 13.5728V13.5728L5.49998 13.5728ZM0.499977 15.4349H0.399977H0.499977ZM0.499977 8.59998H0.599977H0.499977ZM1.99998 11.95V12.05H1.99998L1.99998 11.95ZM4.03419 11.9499L4.03419 12.0499H4.03421L4.03419 11.9499ZM4.63522 11.9741L4.6219 12.0732L4.63522 11.9741ZM5.31315 12.2868L5.24244 12.3575V12.3575L5.31315 12.2868ZM5.62587 12.9647L5.72498 12.9514L5.62587 12.9647ZM5.64998 13.5657L5.54998 13.5657V13.5657H5.64998ZM5.64998 15.4349H5.54998H5.64998ZM4.34654 13.2593L4.44647 13.2556L4.44296 13.161L4.3483 13.1594L4.34654 13.2593ZM4.08788 13.2562L4.08701 13.3562H4.08701L4.08788 13.2562ZM3.29853 13.2521L3.29885 13.1521L3.29853 13.2521ZM4.63479 13.098L4.7339 13.0846L4.73386 13.0844L4.63479 13.098ZM5.34998 15.4349H5.24998H5.34998ZM5.34998 13.5727L5.24998 13.5727V13.5727H5.34998ZM5.32855 13.0047L5.22944 13.018L5.32855 13.0047ZM5.10102 12.4989L5.03031 12.5696V12.5696L5.10102 12.4989ZM4.59525 12.2714L4.58192 12.3705L4.59525 12.2714ZM4.02721 12.2499L4.02721 12.3499H4.02723L4.02721 12.2499ZM1.99998 12.25V12.35H1.99998L1.99998 12.25ZM3.29949 12.9521L3.29982 12.8521L3.29949 12.9521ZM4.0905 12.9562L4.08962 13.0562H4.08962L4.0905 12.9562ZM4.36104 12.9596L4.36289 12.8596H4.36289L4.36104 12.9596ZM4.50198 12.9651L4.51556 12.8661L4.5153 12.866L4.50198 12.9651ZM11.9728 12.0975L11.9728 12.1975H11.9728L11.9728 12.0975ZM11.3847 12.1202L11.3714 12.0211L11.3847 12.1202ZM10.7929 12.3902L10.8636 12.4609L10.7929 12.3902ZM10.5227 12.9816L10.4236 12.9683L10.5227 12.9816ZM10.5 13.5693L10.4 13.5694V13.5694L10.5 13.5693ZM15.5 15.43H15.6H15.5ZM15.5 8.59997H15.4H15.5ZM14 11.9474V12.0474V11.9474ZM11.9658 11.9474L11.9657 12.0474H11.9658V11.9474ZM11.3647 11.9715L11.3514 11.8724L11.3647 11.9715ZM10.6868 12.284L10.7575 12.3548L10.6868 12.284ZM10.3741 12.9616L10.275 12.9483L10.3741 12.9616ZM10.35 13.5623H10.45V13.5623L10.35 13.5623ZM10.35 15.43H10.45H10.35ZM11.6534 13.2562L11.6517 13.1562L11.557 13.1579L11.5535 13.2525L11.6534 13.2562ZM11.9121 13.2531L11.9129 13.3531H11.913L11.9121 13.2531ZM12.7014 13.2489L12.7018 13.3489L12.7014 13.2489ZM11.3652 13.0948L11.2661 13.0812L11.2661 13.0815L11.3652 13.0948ZM10.65 15.43H10.75H10.65ZM10.65 13.5693H10.75V13.5693L10.65 13.5693ZM10.6714 13.0016L10.5723 12.9883V12.9883L10.6714 13.0016ZM10.8989 12.4962L10.9696 12.567L10.8989 12.4962ZM11.4047 12.2689L11.3914 12.1697H11.3914L11.4047 12.2689ZM11.9727 12.2474L11.9727 12.3474H11.9727V12.2474ZM14 12.2474V12.3474V12.2474ZM12.7005 12.9489L12.7008 13.0489L12.7005 12.9489ZM11.9095 12.9531L11.9086 12.8531L11.9095 12.9531ZM11.6389 12.9564L11.6371 12.8564L11.6389 12.9564ZM11.498 12.962L11.4847 12.8629L11.4844 12.8629L11.498 12.962ZM13.1428 6.85712C12.564 6.85712 12.0562 6.55253 11.7712 6.09441L11.6014 6.20007C11.9214 6.7144 12.492 7.05712 13.1428 7.05712V6.85712ZM11.7712 6.09441C11.653 5.90451 11.4033 5.84635 11.2134 5.96451L11.319 6.13433C11.4152 6.07452 11.5415 6.10395 11.6014 6.20007L11.7712 6.09441ZM11.2134 5.96451C11.1564 5.99997 11.1091 6.04902 11.0758 6.10727L11.2494 6.20658C11.2663 6.1771 11.2902 6.15227 11.319 6.13433L11.2134 5.96451ZM11.0758 6.10726C11.064 6.12791 11.0521 6.14675 11.0402 6.16385L11.2044 6.2781C11.2199 6.25571 11.2349 6.23185 11.2494 6.20659L11.0758 6.10726ZM11.0402 6.16385C10.7484 6.58308 10.2633 6.85712 9.71427 6.85712V7.05712C10.3316 7.05712 10.8768 6.74875 11.2044 6.2781L11.0402 6.16385ZM9.71427 6.85712C9.16583 6.85712 8.68124 6.58372 8.38935 6.16533L8.22532 6.27977C8.55302 6.74947 9.09771 7.05712 9.71427 7.05712V6.85712ZM8.38935 6.16533C8.2392 5.95011 7.94301 5.89736 7.72778 6.04751L7.84222 6.21154C7.96685 6.12459 8.13837 6.15513 8.22532 6.27977L8.38935 6.16533ZM7.72778 6.04751C7.67938 6.08128 7.63768 6.12378 7.60484 6.17282L7.77102 6.2841C7.79004 6.2557 7.81418 6.23109 7.84222 6.21154L7.72778 6.04751ZM7.60473 6.17299C7.59903 6.18154 7.59327 6.18975 7.58747 6.19765L7.74864 6.31608C7.75623 6.30574 7.76374 6.29502 7.77114 6.28393L7.60473 6.17299ZM7.58747 6.19765C7.29348 6.59775 6.81988 6.85712 6.28569 6.85712V7.05712C6.88621 7.05712 7.41858 6.76526 7.74864 6.31608L7.58747 6.19765ZM6.28569 6.85712C5.77002 6.85712 5.31085 6.61544 5.01515 6.23876L4.85783 6.36226C5.18981 6.78515 5.70602 7.05712 6.28569 7.05712V6.85712ZM5.01515 6.23876C5.01284 6.23583 5.01054 6.23283 5.00823 6.22979L4.84884 6.35059C4.85181 6.35452 4.85481 6.35841 4.85783 6.36226L5.01515 6.23876ZM5.00824 6.2298C4.82543 5.98854 4.48166 5.94121 4.24044 6.12403L4.36124 6.28342C4.51444 6.16731 4.73275 6.19738 4.84883 6.35058L5.00824 6.2298ZM4.24044 6.12403C4.20162 6.15346 4.16689 6.18793 4.13718 6.22653L4.29567 6.34852C4.31454 6.324 4.33659 6.30211 4.36124 6.28342L4.24044 6.12403ZM4.13718 6.22653C3.84187 6.61019 3.37835 6.85712 2.85712 6.85712V7.05712C3.44305 7.05712 3.96413 6.77925 4.29567 6.34852L4.13718 6.22653ZM2.85712 6.85712C1.96558 6.85712 1.24284 6.13438 1.24284 5.24283H1.04284C1.04284 6.24484 1.85512 7.05712 2.85712 7.05712V6.85712ZM1.24284 5.24283C1.24284 5.26358 1.23367 5.2732 1.23736 5.26821C1.24007 5.26455 1.24729 5.25649 1.26234 5.24395C1.29225 5.21901 1.3399 5.1871 1.40664 5.14768C1.53937 5.06929 1.73137 4.97058 1.96852 4.85001C2.44053 4.61003 3.08142 4.28844 3.74468 3.88662C4.40774 3.48492 5.0967 3.00098 5.66527 2.43433C6.23358 1.86794 6.68654 1.21401 6.86863 0.471931L6.67439 0.424269C6.50407 1.11839 6.07723 1.7414 5.52409 2.29267C4.97121 2.84369 4.29705 3.31814 3.64105 3.71556C2.98524 4.11287 2.35111 4.43113 1.87788 4.67173C1.64241 4.79145 1.44423 4.89321 1.30493 4.97547C1.23566 5.01638 1.17684 5.05484 1.13427 5.09033C1.11309 5.10799 1.09257 5.12765 1.07661 5.14923C1.06162 5.16947 1.04284 5.20183 1.04284 5.24283H1.24284ZM6.86863 0.471931C6.90781 0.312267 7.05103 0.199976 7.21548 0.199976V-2.44156e-05C6.95899 -2.44156e-05 6.73553 0.175111 6.67439 0.424269L6.86863 0.471931ZM7.21548 0.199976L8.78457 0.200046L8.78458 4.6432e-05L7.21549 -2.44156e-05L7.21548 0.199976ZM8.78458 0.200046C8.949 0.200046 9.09217 0.312328 9.13136 0.472015L9.3256 0.424347C9.26446 0.175219 9.0411 4.6432e-05 8.78458 4.6432e-05V0.200046ZM9.13136 0.472015C9.31345 1.21399 9.7664 1.86784 10.3347 2.43417C10.9033 3.00076 11.5922 3.48466 12.2553 3.88636C12.9185 4.28817 13.5594 4.60978 14.0314 4.8498C14.2686 4.97039 14.4606 5.06913 14.5933 5.14755C14.66 5.18698 14.7077 5.21891 14.7376 5.24386C14.7526 5.25641 14.7599 5.26448 14.7626 5.26814C14.7663 5.27313 14.7571 5.26354 14.7571 5.24283H14.9571C14.9571 5.20185 14.9384 5.16949 14.9234 5.14922C14.9074 5.12764 14.8869 5.10796 14.8657 5.09028C14.8231 5.05477 14.7643 5.01629 14.695 4.97536C14.5557 4.89306 14.3576 4.79126 14.1221 4.67152C13.6489 4.43088 13.0147 4.1126 12.3589 3.7153C11.7029 3.31788 11.0288 2.84346 10.4759 2.2925C9.92274 1.74128 9.49591 1.11836 9.3256 0.424347L9.13136 0.472015ZM14.7571 5.24283C14.7571 6.13438 14.0344 6.85712 13.1428 6.85712V7.05712C14.1448 7.05712 14.9571 6.24484 14.9571 5.24283H14.7571ZM8.47141 6.3857V15.5286H8.67141V6.3857H8.47141ZM7.52855 15.5286V6.3857H7.32855V15.5286H7.52855ZM7.99998 16C7.73962 16 7.52855 15.7889 7.52855 15.5286H7.32855C7.32855 15.8994 7.62916 16.2 7.99998 16.2V16ZM8.47141 15.5286C8.47141 15.7889 8.26034 16 7.99998 16V16.2C8.3708 16.2 8.67141 15.8994 8.67141 15.5286H8.47141ZM7.99998 5.91427C8.26034 5.91427 8.47141 6.12534 8.47141 6.3857H8.67141C8.67141 6.01488 8.3708 5.71427 7.99998 5.71427V5.91427ZM7.99998 5.71427C7.62916 5.71427 7.32855 6.01488 7.32855 6.3857H7.52855C7.52855 6.12534 7.73962 5.91427 7.99998 5.91427V5.71427ZM4.74998 9.19998H11.25V8.99998H4.74998V9.19998ZM11.25 10.5H4.74998V10.7H11.25V10.5ZM4.74998 10.5C4.39099 10.5 4.09998 10.209 4.09998 9.84998H3.89998C3.89998 10.3194 4.28053 10.7 4.74998 10.7V10.5ZM11.9 9.84998C11.9 10.209 11.609 10.5 11.25 10.5V10.7C11.7194 10.7 12.1 10.3194 12.1 9.84998H11.9ZM11.25 9.19998C11.609 9.19998 11.9 9.49099 11.9 9.84998H12.1C12.1 9.38053 11.7194 8.99998 11.25 8.99998V9.19998ZM4.74998 8.99998C4.28053 8.99998 3.89998 9.38053 3.89998 9.84998H4.09998C4.09998 9.49099 4.39099 9.19998 4.74998 9.19998V8.99998ZM1.59998 11.6V8.59998H1.39998V11.6H1.59998ZM4.02716 12C4.0181 12 4.00904 12 3.99998 12V12.2C4.00907 12.2 4.01815 12.2 4.0272 12.2L4.02716 12ZM4.62856 12.0236C4.45057 11.9997 4.23712 11.9999 4.02716 12L4.0272 12.2C4.24131 12.1999 4.43999 12.2001 4.60191 12.2218L4.62856 12.0236ZM5.27779 12.3222C5.07446 12.1188 4.83115 12.0509 4.62856 12.0236L4.60191 12.2218C4.78252 12.2461 4.97649 12.3037 5.13637 12.4636L5.27779 12.3222ZM5.57632 12.9714C5.54908 12.7688 5.48113 12.5255 5.27779 12.3222L5.13637 12.4636C5.29626 12.6235 5.35382 12.8174 5.3781 12.998L5.57632 12.9714ZM5.59998 13.5728C5.60002 13.3628 5.60025 13.1494 5.57632 12.9714L5.3781 12.998C5.39987 13.16 5.40002 13.3586 5.39998 13.5727L5.59998 13.5728ZM5.59998 13.6C5.59998 13.5909 5.59998 13.5819 5.59998 13.5728L5.39998 13.5727C5.39998 13.5818 5.39998 13.5909 5.39998 13.6H5.59998ZM5.59998 15.4349V13.6H5.39998V15.4349H5.59998ZM4.39998 13.6V15.4349H4.59998V13.6H4.39998ZM4.38702 13.1313C4.39869 13.2181 4.39998 13.3471 4.39998 13.6H4.59998C4.59998 13.3532 4.59913 13.208 4.58524 13.1046L4.38702 13.1313ZM1.99998 13.2C2.12484 13.2 2.72145 13.2002 3.29869 13.2021C3.58733 13.203 3.87097 13.2044 4.08832 13.2063C4.19703 13.2072 4.2889 13.2083 4.35644 13.2095C4.39025 13.2102 4.41762 13.2108 4.4378 13.2115C4.46035 13.2123 4.46872 13.2129 4.46866 13.2129L4.49531 13.0147C4.47608 13.0121 4.42431 13.0108 4.36013 13.0096C4.29161 13.0083 4.19898 13.0072 4.09006 13.0063C3.87215 13.0044 3.58808 13.003 3.29933 13.0021C2.7218 13.0002 2.12495 13 1.99998 13V13.2ZM1.59998 15.4349V13.6H1.39998V15.4349H1.59998ZM0.399977 8.59998V15.4349H0.599977V8.59998H0.399977ZM3.99998 12H1.99998V12.2H3.99998V12ZM0.999977 15.8349C0.779063 15.8349 0.599977 15.6558 0.599977 15.4349H0.399977C0.399977 15.7663 0.668607 16.0349 0.999977 16.0349V15.8349ZM1.39998 15.4349C1.39998 15.6558 1.22089 15.8349 0.999977 15.8349V16.0349C1.33135 16.0349 1.59998 15.7663 1.59998 15.4349H1.39998ZM1.99998 13C1.66861 13 1.39998 13.2686 1.39998 13.6H1.59998C1.59998 13.3791 1.77906 13.2 1.99998 13.2V13ZM4.5852 13.1044C4.57881 13.0578 4.54217 13.0211 4.49557 13.0147L4.46841 13.2129C4.42611 13.2071 4.39286 13.1738 4.38706 13.1315L4.5852 13.1044ZM1.39998 11.6C1.39998 11.9313 1.66861 12.2 1.99998 12.2V12C1.77906 12 1.59998 11.8209 1.59998 11.6H1.39998ZM0.999977 7.99998C0.668606 7.99998 0.399977 8.2686 0.399977 8.59998H0.599977C0.599977 8.37906 0.779063 8.19998 0.999977 8.19998V7.99998ZM4.99998 15.8349C4.77906 15.8349 4.59998 15.6558 4.59998 15.4349H4.39998C4.39998 15.7663 4.66861 16.0349 4.99998 16.0349V15.8349ZM0.999977 8.19998C1.22089 8.19998 1.39998 8.37906 1.39998 8.59998H1.59998C1.59998 8.2686 1.33135 7.99998 0.999977 7.99998V8.19998ZM5.39998 15.4349C5.39998 15.6558 5.22089 15.8349 4.99998 15.8349V16.0349C5.33135 16.0349 5.59998 15.7663 5.59998 15.4349H5.39998ZM0.999976 7.84995C0.585762 7.84995 0.249976 8.18574 0.249976 8.59995H0.449976C0.449976 8.29619 0.696219 8.04995 0.999976 8.04995V7.84995ZM1.74998 8.59995C1.74998 8.18574 1.41419 7.84995 0.999976 7.84995V8.04995C1.30373 8.04995 1.54998 8.29619 1.54998 8.59995H1.74998ZM1.74998 11.6V8.59995H1.54998V11.6H1.74998ZM1.99998 11.85C1.8619 11.85 1.74998 11.738 1.74998 11.6H1.54998C1.54998 11.8485 1.75145 12.05 1.99998 12.05V11.85ZM4.64855 11.8749C4.4606 11.8497 4.23903 11.8499 4.03417 11.8499L4.03421 12.0499C4.24285 12.0499 4.44992 12.05 4.6219 12.0732L4.64855 11.8749ZM5.38386 12.2161C5.14793 11.9801 4.8676 11.9044 4.64855 11.8749L4.6219 12.0732C4.81902 12.0997 5.04998 12.165 5.24244 12.3575L5.38386 12.2161ZM5.72498 12.9514C5.69553 12.7323 5.61979 12.452 5.38386 12.2161L5.24244 12.3575C5.4349 12.5499 5.50026 12.7809 5.52677 12.978L5.72498 12.9514ZM5.74998 13.5658C5.75002 13.3609 5.75025 13.1393 5.72498 12.9514L5.52677 12.978C5.54989 13.15 5.55003 13.3571 5.54998 13.5657L5.74998 13.5658ZM4.99998 16.1849C5.41419 16.1849 5.74998 15.8491 5.74998 15.4349H5.54998C5.54998 15.7386 5.30373 15.9849 4.99998 15.9849V16.1849ZM4.24998 15.4349C4.24998 15.8491 4.58576 16.1849 4.99998 16.1849V15.9849C4.69622 15.9849 4.44998 15.7386 4.44998 15.4349H4.24998ZM4.24998 13.6V15.4349H4.44998V13.6H4.24998ZM4.24661 13.2631C4.24945 13.3395 4.24998 13.4445 4.24998 13.6H4.44998C4.44998 13.4453 4.44947 13.3364 4.44647 13.2556L4.24661 13.2631ZM4.08701 13.3562C4.1908 13.3571 4.27884 13.3582 4.34477 13.3593L4.3483 13.1594C4.28149 13.1582 4.19276 13.1571 4.08875 13.1562L4.08701 13.3562ZM3.2982 13.3521C3.58677 13.353 3.87008 13.3543 4.08701 13.3562L4.08875 13.1562C3.87126 13.1543 3.58752 13.153 3.29885 13.1521L3.2982 13.3521ZM1.99998 13.35C2.12475 13.35 2.72119 13.3502 3.2982 13.3521L3.29885 13.1521C2.72154 13.1502 2.12487 13.15 1.99998 13.15V13.35ZM1.74998 13.6C1.74998 13.4619 1.8619 13.35 1.99998 13.35V13.15C1.75145 13.15 1.54998 13.3514 1.54998 13.6H1.74998ZM1.74998 15.4349V13.6H1.54998V15.4349H1.74998ZM0.999976 16.1849C1.41419 16.1849 1.74998 15.8491 1.74998 15.4349H1.54998C1.54998 15.7386 1.30373 15.9849 0.999976 15.9849V16.1849ZM0.249976 15.4349C0.249976 15.8491 0.585762 16.1849 0.999976 16.1849V15.9849C0.696219 15.9849 0.449976 15.7386 0.449976 15.4349H0.249976ZM0.249976 8.59995V15.4349H0.449976V8.59995H0.249976ZM4.62145 12.9988L4.47279 13.0189L4.49947 13.2171L4.64813 13.1971L4.62145 12.9988ZM4.74998 13.6C4.74998 13.3577 4.74946 13.2004 4.7339 13.0846L4.53568 13.1113C4.54903 13.2105 4.54998 13.3517 4.54998 13.6H4.74998ZM4.74998 15.4349V13.6H4.54998V15.4349H4.74998ZM4.99998 15.6849C4.8619 15.6849 4.74998 15.5729 4.74998 15.4349H4.54998C4.54998 15.6834 4.75145 15.8849 4.99998 15.8849V15.6849ZM5.24998 15.4349C5.24998 15.5729 5.13805 15.6849 4.99998 15.6849V15.8849C5.2485 15.8849 5.44998 15.6834 5.44998 15.4349H5.24998ZM5.22944 13.018C5.24959 13.1679 5.25002 13.3554 5.24998 13.5727L5.44998 13.5727C5.45002 13.3597 5.44997 13.1573 5.42766 12.9914L5.22944 13.018ZM5.03031 12.5696C5.15762 12.6969 5.20738 12.8539 5.22944 13.018L5.42766 12.9914C5.40263 12.8052 5.34246 12.5989 5.17173 12.4282L5.03031 12.5696ZM4.58192 12.3705C4.74601 12.3925 4.90299 12.4423 5.03031 12.5696L5.17173 12.4282C5.001 12.2575 4.79471 12.1973 4.60857 12.1723L4.58192 12.3705ZM4.02723 12.3499C4.2445 12.3499 4.43207 12.3503 4.58192 12.3705L4.60857 12.1723C4.44262 12.15 4.24022 12.1499 4.02719 12.1499L4.02723 12.3499ZM1.24998 11.6C1.24998 12.0142 1.58576 12.35 1.99998 12.35V12.15C1.69622 12.15 1.44998 11.9037 1.44998 11.6H1.24998ZM1.24998 8.59995V11.6H1.44998V8.59995H1.24998ZM0.999976 8.34995C1.13805 8.34995 1.24998 8.46188 1.24998 8.59995H1.44998C1.44998 8.35142 1.2485 8.14995 0.999976 8.14995V8.34995ZM0.749976 8.59995C0.749976 8.46188 0.861904 8.34995 0.999976 8.34995V8.14995C0.751448 8.14995 0.549976 8.35142 0.549976 8.59995H0.749976ZM0.749976 15.4349V8.59995H0.549976V15.4349H0.749976ZM0.999976 15.6849C0.861904 15.6849 0.749976 15.5729 0.749976 15.4349H0.549976C0.549976 15.6834 0.751448 15.8849 0.999976 15.8849V15.6849ZM1.24998 15.4349C1.24998 15.5729 1.13805 15.6849 0.999976 15.6849V15.8849C1.2485 15.8849 1.44998 15.6834 1.44998 15.4349H1.24998ZM1.24998 13.6V15.4349H1.44998V13.6H1.24998ZM1.99998 12.85C1.58576 12.85 1.24998 13.1857 1.24998 13.6H1.44998C1.44998 13.2962 1.69622 13.05 1.99998 13.05V12.85ZM3.29982 12.8521C2.72206 12.8502 2.12503 12.85 1.99998 12.85V13.05C2.12492 13.05 2.72171 13.0502 3.29917 13.0521L3.29982 12.8521ZM4.09137 12.8563C3.87304 12.8543 3.58864 12.853 3.29982 12.8521L3.29917 13.0521C3.58789 13.053 3.87186 13.0543 4.08962 13.0562L4.09137 12.8563ZM4.36289 12.8596C4.29364 12.8583 4.20044 12.8572 4.09137 12.8563L4.08962 13.0562C4.19849 13.0572 4.29094 13.0583 4.3592 13.0595L4.36289 12.8596ZM4.5153 12.866C4.4851 12.862 4.42162 12.8607 4.36289 12.8596L4.3592 13.0595C4.42501 13.0608 4.47304 13.0621 4.48865 13.0642L4.5153 12.866ZM4.5811 13.1271L4.60108 12.9785L4.40287 12.9518L4.38288 13.1005L4.5811 13.1271ZM4.73386 13.0844C4.71833 12.9711 4.6288 12.8816 4.51556 12.8661L4.48839 13.0642C4.51276 13.0675 4.53237 13.0872 4.53572 13.1115L4.73386 13.0844ZM4.03419 11.8499L1.99998 11.85L1.99998 12.05L4.03419 12.0499L4.03419 11.8499ZM5.74998 15.4349L5.74998 13.5657H5.54998L5.54998 15.4349H5.74998ZM5.24998 13.5727L5.24998 15.4349H5.44998L5.44998 13.5727H5.24998ZM1.99998 12.35L4.02721 12.3499L4.02721 12.1499L1.99998 12.15L1.99998 12.35ZM14.6 11.5975V8.59997H14.4V11.5975H14.6ZM11.9728 12.1975C11.9818 12.1975 11.9909 12.1975 12 12.1975V11.9975C11.9909 11.9975 11.9818 11.9975 11.9728 11.9975L11.9728 12.1975ZM11.398 12.2193C11.56 12.1976 11.7586 12.1974 11.9728 12.1975L11.9728 11.9975C11.7628 11.9974 11.5494 11.9972 11.3714 12.0211L11.398 12.2193ZM10.8636 12.4609C11.0234 12.3011 11.2174 12.2436 11.398 12.2193L11.3714 12.0211C11.1688 12.0483 10.9255 12.1162 10.7222 12.3194L10.8636 12.4609ZM10.6219 12.995C10.6461 12.8145 10.7037 12.6207 10.8636 12.4609L10.7222 12.3194C10.5188 12.5227 10.4509 12.7658 10.4236 12.9683L10.6219 12.995ZM10.6 13.5693C10.5999 13.3553 10.6001 13.1568 10.6219 12.995L10.4236 12.9683C10.3997 13.1462 10.3999 13.3595 10.4 13.5694L10.6 13.5693ZM10.6 13.5965C10.6 13.5874 10.6 13.5784 10.6 13.5693L10.4 13.5694C10.4 13.5784 10.4 13.5875 10.4 13.5965H10.6ZM10.6 15.43V13.5965H10.4V15.43H10.6ZM11.4 13.5965V15.43H11.6V13.5965H11.4ZM11.4147 13.1015C11.4008 13.2048 11.4 13.3499 11.4 13.5965H11.6C11.6 13.3438 11.6013 13.2149 11.6129 13.1281L11.4147 13.1015ZM14 12.9968C13.875 12.9968 13.2782 12.9971 12.7006 12.999C12.4119 12.9999 12.1278 13.0012 11.9099 13.0031C11.801 13.0041 11.7083 13.0052 11.6398 13.0064C11.5756 13.0076 11.5239 13.009 11.5047 13.0116L11.5313 13.2098C11.5312 13.2098 11.5396 13.2091 11.5622 13.2084C11.5823 13.2077 11.6097 13.207 11.6435 13.2064C11.7111 13.2051 11.8029 13.2041 11.9116 13.2031C12.129 13.2012 12.4126 13.1999 12.7013 13.199C13.2785 13.1971 13.8751 13.1968 14 13.1968V12.9968ZM14.6 15.43V13.5968H14.4V15.43H14.6ZM15.4 8.59997V15.43H15.6V8.59997H15.4ZM12 12.1975H14V11.9975H12V12.1975ZM15 16.03C15.3313 16.03 15.6 15.7613 15.6 15.43H15.4C15.4 15.6509 15.2209 15.83 15 15.83V16.03ZM14.4 15.43C14.4 15.7613 14.6686 16.03 15 16.03V15.83C14.7791 15.83 14.6 15.6509 14.6 15.43H14.4ZM14 13.1968C14.2209 13.1968 14.4 13.3759 14.4 13.5968H14.6C14.6 13.2655 14.3313 12.9968 14 12.9968V13.1968ZM11.6129 13.1284C11.6071 13.1708 11.5738 13.204 11.5316 13.2097L11.5044 13.0116C11.4579 13.018 11.4212 13.0546 11.4148 13.1012L11.6129 13.1284ZM14.4 11.5975C14.4 11.8184 14.2209 11.9975 14 11.9975V12.1975C14.3313 12.1975 14.6 11.9288 14.6 11.5975H14.4ZM15 8.19998C15.2209 8.19998 15.4 8.37906 15.4 8.59997H15.6C15.6 8.2686 15.3313 7.99998 15 7.99998V8.19998ZM11 16.03C11.3314 16.03 11.6 15.7613 11.6 15.43H11.4C11.4 15.6509 11.2209 15.83 11 15.83V16.03ZM15 7.99998C14.6686 7.99998 14.4 8.2686 14.4 8.59997H14.6C14.6 8.37906 14.7791 8.19998 15 8.19998V7.99998ZM10.4 15.43C10.4 15.7613 10.6686 16.03 11 16.03V15.83C10.7791 15.83 10.6 15.6509 10.6 15.43H10.4ZM15 8.04995C15.3037 8.04995 15.55 8.2962 15.55 8.59995H15.75C15.75 8.18574 15.4142 7.84995 15 7.84995V8.04995ZM14.45 8.59995C14.45 8.29619 14.6962 8.04995 15 8.04995V7.84995C14.5858 7.84995 14.25 8.18574 14.25 8.59995H14.45ZM14.45 11.5974V8.59995H14.25V11.5974H14.45ZM14 12.0474C14.2485 12.0474 14.45 11.846 14.45 11.5974H14.25C14.25 11.7355 14.1381 11.8474 14 11.8474V12.0474ZM11.3781 12.0706C11.55 12.0475 11.7571 12.0474 11.9657 12.0474L11.9658 11.8474C11.7609 11.8474 11.5394 11.8472 11.3514 11.8724L11.3781 12.0706ZM10.7575 12.3548C10.95 12.1624 11.181 12.0971 11.3781 12.0706L11.3514 11.8724C11.1324 11.9018 10.8521 11.9775 10.6162 12.2133L10.7575 12.3548ZM10.4732 12.975C10.4997 12.7779 10.5651 12.5471 10.7575 12.3548L10.6162 12.2133C10.3802 12.4491 10.3044 12.7293 10.275 12.9483L10.4732 12.975ZM10.45 13.5623C10.4499 13.3538 10.4501 13.1468 10.4732 12.975L10.275 12.9483C10.2497 13.1361 10.2499 13.3576 10.25 13.5623L10.45 13.5623ZM11 15.98C10.6962 15.98 10.45 15.7337 10.45 15.43H10.25C10.25 15.8442 10.5858 16.18 11 16.18V15.98ZM11.55 15.43C11.55 15.7337 11.3037 15.98 11 15.98V16.18C11.4142 16.18 11.75 15.8442 11.75 15.43H11.55ZM11.55 13.5965V15.43H11.75V13.5965H11.55ZM11.5535 13.2525C11.5505 13.3332 11.55 13.442 11.55 13.5965H11.75C11.75 13.4412 11.7505 13.3363 11.7533 13.2599L11.5535 13.2525ZM11.9112 13.1531C11.8072 13.154 11.7185 13.155 11.6517 13.1562L11.6552 13.3562C11.7211 13.355 11.8092 13.354 11.9129 13.3531L11.9112 13.1531ZM12.7011 13.1489C12.4124 13.1499 12.1287 13.1512 11.9112 13.1531L11.913 13.3531C12.1299 13.3512 12.4132 13.3499 12.7018 13.3489L12.7011 13.1489ZM14 13.1468C13.8751 13.1468 13.2784 13.1471 12.7011 13.1489L12.7018 13.3489C13.2788 13.3471 13.8752 13.3468 14 13.3468V13.1468ZM14.45 13.5968C14.45 13.3483 14.2485 13.1468 14 13.1468V13.3468C14.1381 13.3468 14.25 13.4587 14.25 13.5968H14.45ZM14.45 15.43V13.5968H14.25V15.43H14.45ZM15 15.98C14.6962 15.98 14.45 15.7337 14.45 15.43H14.25C14.25 15.8442 14.5858 16.18 15 16.18V15.98ZM15.55 15.43C15.55 15.7337 15.3037 15.98 15 15.98V16.18C15.4142 16.18 15.75 15.8442 15.75 15.43H15.55ZM15.55 8.59995V15.43H15.75V8.59995H15.55ZM11.3518 13.1939L11.5005 13.2139L11.5272 13.0157L11.3785 12.9957L11.3518 13.1939ZM11.45 13.5965C11.45 13.3484 11.4509 13.2073 11.4643 13.1081L11.2661 13.0815C11.2505 13.1972 11.25 13.3544 11.25 13.5965H11.45ZM11.45 15.43V13.5965H11.25V15.43H11.45ZM11 15.88C11.2485 15.88 11.45 15.6785 11.45 15.43H11.25C11.25 15.568 11.1381 15.68 11 15.68V15.88ZM10.55 15.43C10.55 15.6785 10.7515 15.88 11 15.88V15.68C10.8619 15.68 10.75 15.568 10.75 15.43H10.55ZM10.5723 12.9883C10.55 13.1541 10.5499 13.3564 10.55 13.5693L10.75 13.5693C10.7499 13.3521 10.7504 13.1647 10.7705 13.015L10.5723 12.9883ZM10.8282 12.4255C10.6575 12.5961 10.5973 12.8023 10.5723 12.9883L10.7705 13.015C10.7926 12.851 10.8423 12.6942 10.9696 12.567L10.8282 12.4255ZM11.3914 12.1697C11.2052 12.1948 10.999 12.2549 10.8282 12.4255L10.9696 12.567C11.0969 12.4397 11.2539 12.39 11.418 12.368L11.3914 12.1697ZM11.9728 12.1474C11.7597 12.1474 11.5573 12.1474 11.3914 12.1697L11.418 12.368C11.5679 12.3478 11.7555 12.3474 11.9727 12.3474L11.9728 12.1474ZM14.55 11.5974C14.55 11.9012 14.3037 12.1474 14 12.1474V12.3474C14.4142 12.3474 14.75 12.0117 14.75 11.5974H14.55ZM14.55 8.59995V11.5974H14.75V8.59995H14.55ZM15 8.14995C14.7515 8.14995 14.55 8.35142 14.55 8.59995H14.75C14.75 8.46188 14.8619 8.34995 15 8.34995V8.14995ZM15.45 8.59995C15.45 8.35142 15.2485 8.14995 15 8.14995V8.34995C15.1381 8.34995 15.25 8.46188 15.25 8.59995H15.45ZM15.45 15.43V8.59995H15.25V15.43H15.45ZM15 15.88C15.2485 15.88 15.45 15.6785 15.45 15.43H15.25C15.25 15.568 15.1381 15.68 15 15.68V15.88ZM14.55 15.43C14.55 15.6785 14.7515 15.88 15 15.88V15.68C14.8619 15.68 14.75 15.568 14.75 15.43H14.55ZM14.55 13.5968V15.43H14.75V13.5968H14.55ZM14 13.0468C14.3037 13.0468 14.55 13.2931 14.55 13.5968H14.75C14.75 13.1826 14.4142 12.8468 14 12.8468V13.0468ZM12.7008 13.0489C13.2782 13.0471 13.875 13.0468 14 13.0468V12.8468C13.8749 12.8468 13.2779 12.8471 12.7001 12.8489L12.7008 13.0489ZM11.9103 13.0531C12.1281 13.0512 12.4121 13.0499 12.7008 13.0489L12.7001 12.8489C12.4113 12.8499 12.1269 12.8512 11.9086 12.8531L11.9103 13.0531ZM11.6408 13.0564C11.709 13.0551 11.8015 13.054 11.9103 13.0531L11.9086 12.8531C11.7995 12.8541 11.7063 12.8552 11.6371 12.8564L11.6408 13.0564ZM11.5113 13.0611C11.5269 13.059 11.575 13.0576 11.6408 13.0564L11.6371 12.8564C11.5783 12.8575 11.5149 12.8588 11.4847 12.8629L11.5113 13.0611ZM11.6171 13.0974L11.5971 12.9487L11.3989 12.9753L11.4189 13.124L11.6171 13.0974ZM11.4642 13.1084C11.4676 13.084 11.4872 13.0644 11.5116 13.0611L11.4844 12.8629C11.3713 12.8784 11.2817 12.9677 11.2661 13.0812L11.4642 13.1084ZM11.9658 12.0474L14 12.0474V11.8474L11.9658 11.8474V12.0474ZM10.45 15.43L10.45 13.5623H10.25L10.25 15.43H10.45ZM10.55 13.5693L10.55 15.43H10.75L10.75 13.5693H10.55ZM14 12.1474L11.9727 12.1474V12.3474L14 12.3474V12.1474Z"
            fill={props.fill}
        />
    </svg>
);

PatioIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PatioIcon;
