import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlaidIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.9211 1.69995H8.70407C8.05869 1.69994 7.43957 1.95546 6.982 2.41061C6.52443 2.86576 6.26561 3.48352 6.2622 4.1289V8.94807C6.2622 9.56143 6.50587 10.1496 6.93958 10.5833C7.37328 11.017 7.96155 11.2607 8.57491 11.2607H11.7158C11.8322 11.2753 11.9504 11.265 12.0625 11.2305C12.1746 11.196 12.2779 11.138 12.3659 11.0604C12.4539 10.9828 12.5243 10.8874 12.5725 10.7805C12.6208 10.6736 12.6458 10.5576 12.6458 10.4403C12.6458 10.323 12.6208 10.207 12.5725 10.1001C12.5243 9.99318 12.4539 9.89782 12.3659 9.82023C12.2779 9.74263 12.1746 9.68459 12.0625 9.65006C11.9504 9.61552 11.8322 9.60522 11.7158 9.61985H8.49997C8.32864 9.61985 8.16438 9.55182 8.04323 9.43068C7.92208 9.30953 7.85398 9.14519 7.85398 8.97386C7.85398 8.80253 7.92208 8.63827 8.04323 8.51712C8.16438 8.39597 8.32864 8.32786 8.49997 8.32786H11.7158C12.0071 8.30507 12.2999 8.34276 12.576 8.43858C12.852 8.5344 13.1052 8.68629 13.3198 8.88467C13.5343 9.08305 13.7053 9.32368 13.8224 9.59139C13.9394 9.8591 14 10.1481 14 10.4403C14 10.7325 13.9394 11.0215 13.8224 11.2892C13.7053 11.5569 13.5343 11.7975 13.3198 11.9959C13.1052 12.1943 12.852 12.3462 12.576 12.442C12.2999 12.5378 12.0071 12.5755 11.7158 12.5527H8.57491C7.61889 12.5527 6.7021 12.1729 6.0261 11.4969C5.3501 10.8209 4.97021 9.90409 4.97021 8.94807V4.14183H1.09424C0.922909 4.14183 0.758646 4.20994 0.637498 4.33109C0.516351 4.45223 0.448242 4.6165 0.448242 4.78783C0.448242 4.95915 0.516351 5.12349 0.637498 5.24464C0.758646 5.36579 0.922909 5.43382 1.09424 5.43382H2.59299V7.06174H1.09424C0.922909 7.06174 0.758646 7.12977 0.637498 7.25092C0.516351 7.37206 0.448242 7.53641 0.448242 7.70773C0.448242 7.87906 0.516351 8.0434 0.637498 8.16455C0.758646 8.2857 0.922909 8.35373 1.09424 8.35373H2.59299V9.98165H1.09424C0.922909 9.98165 0.758646 10.0497 0.637498 10.1708C0.516351 10.292 0.448242 10.4563 0.448242 10.6276C0.448242 10.799 0.516351 10.9632 0.637498 11.0844C0.758646 11.2055 0.922909 11.2736 1.09424 11.2736H2.59299V12.9532H1.09424C0.922909 12.9532 0.758646 13.0212 0.637498 13.1424C0.516351 13.2635 0.448242 13.4279 0.448242 13.5992C0.448242 13.7705 0.516351 13.9349 0.637498 14.056C0.758646 14.1772 0.922909 14.2452 1.09424 14.2452H11.8695C12.3389 14.2452 12.8036 14.1525 13.2371 13.9725C13.6706 13.7925 14.0642 13.5287 14.3955 13.1962C14.7268 12.8638 14.9892 12.4691 15.1677 12.035C15.3461 11.6009 15.437 11.1357 15.4353 10.6664V5.33044C15.4438 4.86107 15.3597 4.39468 15.1875 3.95794C15.0154 3.52119 14.7587 3.12272 14.4322 2.78541C14.1057 2.44811 13.7158 2.17862 13.2849 1.99235C12.854 1.80609 12.3905 1.70668 11.9211 1.69995Z"
            fill={props.fill}
        />
    </svg>
);

PlaidIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PlaidIcon;
