import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const RestaurantIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.5 6.66667C12.8043 8 11.8043 8.66667 10.5 8.66667C9.19565 8.66667 8.19565 8 7.5 6.66667L7.74523 0.399681C7.75397 0.176405 7.93358 0 8.15217 0H8.4194C8.48891 0 8.5462 0.0557137 8.54967 0.126675L8.77174 4.66667H9.88043L10.1025 0.126675C10.106 0.0557137 10.1633 0 10.2328 0H10.7672C10.8367 0 10.894 0.0557137 10.8975 0.126675L11.1196 4.66667H12.2283L12.4503 0.126675C12.4538 0.0557137 12.5111 0 12.5806 0H12.8478C13.0664 0 13.246 0.176405 13.2548 0.399681L13.5 6.66667ZM11.2236 9.23627L11.3935 15.3143C11.4038 15.6823 11.1202 15.9892 10.7602 15.9997C10.754 15.9999 10.7478 16 10.7416 16H10.2576C9.89746 16 9.60547 15.7015 9.60547 15.3333C9.60547 15.327 9.60556 15.3206 9.60573 15.3143L9.77562 9.23627C10.0169 9.30098 10.2583 9.33333 10.4996 9.33333C10.7409 9.33333 10.9823 9.30098 11.2236 9.23627ZM6.00033 0.703641V16H5.52139C4.78501 16 4.18806 15.4031 4.18806 14.6667C4.18806 14.6489 4.18841 14.6311 4.18912 14.6134L4.40033 9.33334C4.13366 8.64053 3.55588 8.19609 2.66699 8C2.66699 4.45212 3.39045 1.87162 4.83737 0.258497L4.83736 0.258489C5.08321 -0.0156018 5.50471 -0.0384954 5.7788 0.207355C5.91978 0.33381 6.00033 0.514257 6.00033 0.703641Z"
            fill={props.fill}
        />
    </svg>
);

RestaurantIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default RestaurantIcon;
