import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SearchIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.25 12.5C2.79822 12.5 0 9.70178 0 6.25C0 2.79822 2.79822 0 6.25 0C9.70178 0 12.5 2.79822 12.5 6.25C12.5 7.61497 12.0624 8.87775 11.3199 9.9057L15.2071 13.7929C15.5976 14.1834 15.5976 14.8166 15.2071 15.2071C14.8166 15.5976 14.1834 15.5976 13.7929 15.2071L9.9057 11.3199C8.87775 12.0624 7.61497 12.5 6.25 12.5ZM6.25 10.5C8.59721 10.5 10.5 8.59721 10.5 6.25C10.5 3.90279 8.59721 2 6.25 2C3.90279 2 2 3.90279 2 6.25C2 8.59721 3.90279 10.5 6.25 10.5Z"
            fill={props.fill}
        />
    </svg>
);

SearchIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SearchIcon;
