import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShareFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.8001 2.90301C14.7999 3.4304 14.6453 3.94619 14.3553 4.38671C14.0654 4.82722 13.6527 5.17317 13.1684 5.38184C12.684 5.59052 12.1492 5.65277 11.6299 5.56092C11.1105 5.46908 10.6295 5.22715 10.2461 4.86501L5.50308 7.28301C5.63308 7.75401 5.63308 8.25201 5.50308 8.72301L10.2461 11.14C10.7058 10.7058 11.3032 10.4468 11.9344 10.408C12.5655 10.3692 13.1902 10.5531 13.6996 10.9277C14.209 11.3023 14.5708 11.8438 14.7218 12.4578C14.8729 13.0718 14.8037 13.7194 14.5262 14.2876C14.2488 14.8558 13.7807 15.3086 13.2036 15.567C12.6266 15.8255 11.9771 15.8732 11.3684 15.7019C10.7598 15.5306 10.2306 15.151 9.87304 14.6295C9.51552 14.108 9.35239 13.4775 9.41208 12.848L4.36208 10.273C3.95426 10.5356 3.48323 10.6836 2.99848 10.7012C2.51374 10.7189 2.03319 10.6056 1.60735 10.3734C1.1815 10.1411 0.826097 9.79839 0.578483 9.38129C0.33087 8.96418 0.200195 8.48808 0.200195 8.00301C0.200195 7.51794 0.33087 7.04184 0.578483 6.62473C0.826097 6.20763 1.1815 5.86493 1.60735 5.63266C2.03319 5.4004 2.51374 5.28714 2.99848 5.3048C3.48323 5.32246 3.95426 5.47038 4.36208 5.73301L9.41208 3.15801C9.37768 2.79438 9.41742 2.42755 9.52889 2.07972C9.64036 1.73189 9.82125 1.41029 10.0606 1.1344C10.3 0.858497 10.5928 0.634031 10.9214 0.474584C11.25 0.315136 11.6076 0.224022 11.9724 0.206754C12.3373 0.189487 12.7018 0.246426 13.044 0.374126C13.3862 0.501825 13.699 0.69763 13.9633 0.94969C14.2277 1.20175 14.4381 1.50482 14.5819 1.84057C14.7258 2.17632 14.8 2.53776 14.8001 2.90301Z"
            fill={props.fill}
        />
    </svg>
);

ShareFilledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ShareFilledIcon;
