import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SingleBedIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.49917 3C3.67074 3 3 3.67157 3 4.5V8.30647C3.12369 8.20822 3.27133 8.13639 3.44401 8.09987C3.72155 8.04117 4.06961 8.00001 4.5 8.00001C4.5 6.5 6 6.5 8 6.5C10 6.5 11.5 6.5 11.5 8.00003C11.9304 8.00003 12.2784 8.04119 12.5559 8.09988C12.7286 8.1364 12.8763 8.20824 13 8.30651V4.5C13 3.67157 12.3293 3 11.5008 3H8H4.49917Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.5 13H3.5L3.19089 13.6182C3.11657 13.7669 3.08053 13.8157 3.03182 13.8633C2.98311 13.9108 2.9278 13.945 2.86347 13.9673C2.79913 13.9896 2.73935 14 2.57315 14H2V10.5C2 9.67158 2.67158 9 3.50001 9.00001L12.5 9.00004C13.3284 9.00004 14 9.67161 14 10.5V14H13.4269C13.2607 14 13.2009 13.9896 13.1365 13.9673C13.0722 13.945 13.0169 13.9108 12.9682 13.8633C12.9195 13.8157 12.8834 13.7669 12.8091 13.6182L12.5 13Z"
            fill={props.fill}
        />
    </svg>
);

SingleBedIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SingleBedIcon;
