import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SleepingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.66054 5.57111C8.22361 5.89512 6.65989 6.06417 5.08209 6.06417C3.50428 6.06417 1.92647 5.89512 0.503628 5.57111C0.278227 5.52885 0.0669146 5.66972 0.0105639 5.89512C-0.00352287 5.95147 -0.00352287 6.00782 0.0105639 6.06417C0.123264 6.68403 0.235965 7.33206 0.32049 8.02235C0.405016 8.69855 0.447279 9.40293 0.447279 10.1355C0.447279 10.8539 0.405016 11.5583 0.32049 12.2345C0.235965 12.9389 0.123264 13.5869 0.0105639 14.2068C-0.0316982 14.4322 0.109177 14.6435 0.334578 14.6858C0.390928 14.6998 0.447278 14.6998 0.503628 14.6858C1.92647 14.3617 3.50428 14.1927 5.08209 14.1927C6.65989 14.1927 8.22361 14.3617 9.66054 14.6858C9.88595 14.728 10.0973 14.5871 10.1536 14.3758C10.1677 14.3054 10.1677 14.249 10.1536 14.1927C10.0409 13.5728 9.92821 12.9248 9.84368 12.2345C9.75916 11.5583 9.7169 10.8539 9.7169 10.1355C9.7169 9.40293 9.75916 8.69855 9.84368 8.02235C9.92821 7.33206 10.0409 6.66994 10.1536 6.05009C10.1959 5.82469 10.055 5.61337 9.8296 5.57111C9.77325 5.55702 9.7169 5.55702 9.66054 5.57111ZM15.5632 2.28871C14.0981 2.35915 12.5203 2.24645 10.9707 1.97878C9.42106 1.69703 7.8996 1.2744 6.54719 0.696814C6.33588 0.612288 6.09639 0.710901 6.01187 0.922215C5.98369 0.978565 5.9696 1.03492 5.98369 1.09127C5.98369 1.72521 5.98369 2.38732 5.94143 3.07761C5.89917 3.75381 5.84282 4.45819 5.71603 5.17666L5.70194 5.21892C6.96982 5.19075 8.25179 5.04987 9.47741 4.76812C9.63237 4.72586 9.81551 4.72586 9.97047 4.75403C10.6467 4.88082 11.0975 5.52885 10.9707 6.20505C10.858 6.83899 10.7453 7.47293 10.6748 8.12096C10.5903 8.78307 10.534 9.45928 10.534 10.1355V10.1777C11.7455 10.4454 12.9148 10.8117 13.9854 11.2625C14.1967 11.347 14.4362 11.2484 14.5208 11.0371C14.5489 10.9807 14.563 10.9244 14.563 10.868C14.5489 10.2341 14.563 9.57198 14.5912 8.88169C14.6335 8.20548 14.7039 7.50111 14.8307 6.78264C14.9575 6.06417 15.1265 5.38797 15.3237 4.72586C15.5351 4.06374 15.7605 3.44389 15.9718 2.85221C16.0563 2.62681 15.9436 2.40141 15.7323 2.31688C15.6759 2.3028 15.6196 2.28871 15.5632 2.28871Z"
            fill={props.fill}
        />
    </svg>
);

SleepingIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SleepingIcon;
