import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SocketIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7 1C7 0.447715 6.55228 0 6 0C5.44772 0 5 0.447715 5 1"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11 1C11 0.447715 10.5523 0 10 0C9.44772 0 9 0.447715 9 1"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7 15C7 15.5523 7.44772 16 8 16C8.55228 16 9 15.5523 9 15"
            fill={props.fill}
        />
        <rect x={5} y={1} width={2} height={3} fill={props.fill} />
        <rect x={9} y={1} width={2} height={3} fill={props.fill} />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3 5C3 4.44772 3.44772 4 4 4H12C12.5523 4 13 4.44772 13 5V9C13 11.2091 11.2091 13 9 13V15H7L7 13C4.79086 13 3 11.2091 3 9V5ZM11 6H5V9C5 10.1046 5.89543 11 7 11H9C10.1046 11 11 10.1046 11 9V6Z"
            fill={props.fill}
        />
    </svg>
);

SocketIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SocketIcon;
