import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SoundproofIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 17 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.7728 5.57225C11.435 5.302 10.9283 5.33578 10.6411 5.69049C10.354 6.04519 10.4216 6.55191 10.7763 6.83905C11.2323 7.21065 11.5194 7.78493 11.5194 8.40989C11.5194 9.08551 11.1985 9.67669 10.6918 10.0483C10.3709 10.2848 10.3202 10.7577 10.5736 11.0617L10.6411 11.1293C10.9114 11.4502 11.4181 11.5178 11.739 11.2644C12.5836 10.6057 13.1241 9.55845 13.1241 8.40989C13.1241 7.26132 12.6004 6.24788 11.7728 5.57225Z"
            fill={props.fill}
        />
        <path
            d="M13.6138 3.30899C13.276 3.03874 12.7862 3.10631 12.499 3.42723C12.2288 3.76504 12.2625 4.27176 12.6004 4.54201C13.7151 5.471 14.4414 6.85604 14.4414 8.40998C14.4414 9.96392 13.7151 11.3658 12.6004 12.2779C12.2625 12.5482 12.2288 13.0549 12.499 13.3927C12.7693 13.7305 13.276 13.7981 13.6138 13.5279C15.1002 12.3286 16.0629 10.4875 16.0629 8.42687C16.0461 6.34932 15.1002 4.50823 13.6138 3.30899Z"
            fill={props.fill}
        />
        <path
            d="M7.0603 2.07588L2.95587 5.23443H0.945878C0.422267 5.23443 0 5.6567 0 6.18031V10.6395C0 11.1631 0.422267 11.5853 0.945878 11.5853H2.95587L7.07719 14.7439C7.80349 15.3013 8.83382 14.7946 8.83382 13.8656V2.9373C8.83382 2.04209 7.7866 1.51848 7.0603 2.07588Z"
            fill={props.fill}
        />
        <path
            d="M14.955 16.998C14.6742 16.9808 14.4115 16.8541 14.2233 16.6451L1.28584 1.76219C1.10504 1.54675 1.01609 1.26892 1.03814 0.988536C1.0602 0.708152 1.1915 0.447649 1.40376 0.263132C1.61602 0.0786156 1.89226 -0.0151501 2.17299 0.00203024C2.45371 0.0192106 2.71646 0.145962 2.90464 0.354986L15.8421 15.2379C16.0229 15.4533 16.1119 15.7311 16.0898 16.0115C16.0678 16.2919 15.9365 16.5524 15.7242 16.7369C15.5119 16.9214 15.2357 17.0152 14.955 16.998Z"
            fill="white"
        />
        <path
            d="M12.4203 16.2327C12.1747 16.2177 11.9448 16.1068 11.7801 15.9239L0.459839 2.90136C0.301639 2.71285 0.223807 2.46975 0.243106 2.22441C0.262405 1.97908 0.377291 1.75114 0.56302 1.58969C0.74875 1.42823 0.990461 1.34619 1.2361 1.36122C1.48173 1.37625 1.71163 1.48716 1.87629 1.67006L13.1966 14.6926C13.3548 14.8811 13.4326 15.1242 13.4133 15.3695C13.394 15.6148 13.2791 15.8428 13.0934 16.0042C12.9077 16.1657 12.666 16.2477 12.4203 16.2327Z"
            fill={props.fill}
        />
    </svg>
);

SoundproofIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SoundproofIcon;
