import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 17 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.98393 13.1325L11.6199 15.0285C12.5899 15.5345 13.5239 14.8625 13.3399 13.7885L12.6459 9.7725C12.6519 9.8125 12.6659 9.7765 12.6339 9.8045L15.5799 6.9605C16.3639 6.2005 16.0059 5.1105 14.9199 4.9545L10.8599 4.3665C10.8999 4.3725 10.8699 4.3505 10.8859 4.3865L9.05993 0.7305C8.57993 -0.2435 7.41993 -0.2435 6.93993 0.7305L5.11993 4.3865C5.13993 4.3505 5.10593 4.3725 5.14593 4.3665L1.07993 4.9545C-0.00407135 5.1105 -0.360071 6.2005 0.419929 6.9585L3.36793 9.8005C3.33793 9.7725 3.34793 9.8085 3.35793 9.7685L2.66193 13.7885C2.47793 14.8565 3.41193 15.5285 4.38193 15.0285L8.01793 13.1285C7.98393 13.1485 8.02193 13.1485 7.98593 13.1285L7.98393 13.1325Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default StarIcon;
