import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SuburbanIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.1333 2.13333L10.8667 0.666667H11.6667V0.333333C11.6667 0.133333 11.5333 0 11.3333 0H5.33333C5.13333 0 5 0.133333 5 0.333333V0.666667H5.8L6.53333 2.13333C4.46667 2.4 3 3.13333 3 4V11.3333C3 11.7333 3.26667 12 3.66667 12H13C13.4 12 13.6667 11.7333 13.6667 11.3333V4C13.6667 3.13333 12.2 2.4 10.1333 2.13333ZM10.0007 0.666667L9.33398 2.06667C9.00065 2 8.66732 2 8.33398 2C8.00065 2 7.66732 2 7.33398 2.06667L6.66732 0.666667H10.0007ZM8.33398 4.66667C8.73398 4.66667 9.00065 4.4 9.00065 4C9.00065 3.6 8.73398 3.33333 8.33398 3.33333C7.93398 3.33333 7.66732 3.6 7.66732 4C7.66732 4.4 7.93398 4.66667 8.33398 4.66667ZM6.33138 10.6667H4.33138V9.33333H6.33138V10.6667ZM10.3314 10.6667H12.3314V9.33333H10.3314V10.6667ZM12.3314 8H4.33138V5.33333H12.3314V8ZM5.53398 14H5.00065C4.26732 14 3.66732 13.4 3.66732 12.6667H13.0007C13.0007 13.4 12.4007 14 11.6673 14H11.2007L12.2007 16H10.8673L9.86732 14H6.80065L5.80065 16H4.53398L5.53398 14Z"
            fill={props.fill}
        />
    </svg>
);

SuburbanIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SuburbanIcon;
