import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SwapIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 16 16" fill="none" focusable={false} {...props}>
        <g clipPath="url(#prefix__clip0)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M.603 4.2a.5.5 0 0 0 .4.8h2v10a1 1 0 1 0 2 0V5h2a.5.5 0 0 0 .4-.8l-3-3.997a.5.5 0 0 0-.8 0l-3 3.997zm12.4 6.8h2a.5.5 0 0 1 .4.8l-3 3.997a.5.5 0 0 1-.8 0l-3-3.997a.5.5 0 0 1 .4-.8h2V1a1 1 0 1 1 2 0v10z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="prefix__clip0">
                <path d="M0 16V0h16v16H0z" fill="#fff" />
            </clipPath>
        </defs>
    </svg>
);

SwapIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SwapIcon;
