import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ToursIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.89592 2.4795C4.14065 1.6222 5.60278 1.13505 7.11296 1.07446C8.62314 1.01386 10.1196 1.38231 11.429 2.13713C12.7384 2.89194 13.8072 4.00225 14.5117 5.33945C15.2161 6.67666 15.5273 8.18605 15.4092 9.69283C15.4053 9.76974 15.3857 9.85596 15.3814 9.86987C15.0342 10.5013 12.2361 9.50878 8.98467 7.69159L7.27862 10.6673H5.7316L7.83695 7.02611C4.67165 5.12155 2.45692 3.18883 2.79592 2.58617C2.82317 2.54536 2.85695 2.50932 2.89592 2.4795ZM9.00258 6.35284C9.96212 6.91485 10.9526 7.42232 11.9692 7.87283C12.5492 5.67283 12.3226 3.53284 11.0493 2.7995C9.77592 2.06617 7.80925 2.9395 6.19592 4.5395C7.09902 5.19276 8.03587 5.79804 9.00258 6.35284ZM15.2267 4.59262C15.2255 4.61038 15.2255 4.6282 15.2267 4.64596C15.2279 4.6282 15.2279 4.61038 15.2267 4.59262ZM3.33333 8.66596L5.33333 11.3326H11.3333C11.687 11.3326 12.0261 11.4731 12.2761 11.7231C12.5262 11.9732 12.6667 12.3123 12.6667 12.666V14.666H11.3333L10 13.3326H4L2.66667 14.666H1.33333L2.66667 12.4193L0 8.66596H3.33333Z"
            fill={props.fill}
        />
    </svg>
);

ToursIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ToursIcon;
