import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.04 0.666656H6.96C6.67966 0.666403 6.40636 0.75452 6.17897 0.918485C5.95157 1.08245 5.78164 1.31392 5.69333 1.57999L5.48205 2.21775C4.94669 2.31104 4.41628 2.43413 3.89333 2.58666C3.34549 2.75267 2.8656 3.09056 2.52464 3.55038C2.18367 4.01021 1.99973 4.56755 2 5.13999V11.5267C1.99973 12.0991 2.18367 12.6564 2.52464 13.1163C2.8656 13.5761 3.34549 13.914 3.89333 14.08L4.3 14.1933L5.0879 13.0293C5.17417 12.9386 5.27477 12.862 5.38607 12.8029C5.55455 12.7135 5.74239 12.6667 5.93314 12.6667H5.93333H10.0133C10.2081 12.6672 10.3997 12.7163 10.5708 12.8094C10.7419 12.9025 10.8871 13.0367 10.9933 13.2L11.66 14.2C11.8133 14.1667 11.96 14.1267 12.1067 14.08C12.6545 13.914 13.1344 13.5761 13.4754 13.1163C13.8163 12.6564 14.0003 12.0991 14 11.5267V5.13999C14.0003 4.56755 13.8163 4.01021 13.4754 3.55038C13.1344 3.09056 12.6545 2.75267 12.1067 2.58666C11.5837 2.43413 11.0533 2.31104 10.5179 2.21775L10.3067 1.57999C10.2184 1.31392 10.0484 1.08245 9.82104 0.918485C9.59364 0.75452 9.32034 0.666403 9.04 0.666656ZM12.6667 7.0341V5.13999C12.667 4.85602 12.5766 4.57937 12.4087 4.35034C12.2408 4.1213 12.0042 3.95185 11.7333 3.86666C10.5204 3.5129 9.26343 3.33332 8 3.33332C6.73657 3.33332 5.47955 3.5129 4.26666 3.86666C3.99577 3.95185 3.75916 4.1213 3.59128 4.35034C3.4234 4.57937 3.33303 4.85602 3.33333 5.13999V7.0341C3.62817 7.20795 4.05339 7.33332 4.66667 7.33332H11.3333C11.9466 7.33332 12.3718 7.20795 12.6667 7.0341ZM3.33333 9.33332V10.6667H6C6 10.313 5.85953 9.9739 5.60948 9.72385C5.35943 9.4738 5.02029 9.33332 4.66667 9.33332H3.33333ZM12.6667 10.6667V9.33332H11.3333C10.9797 9.33332 10.6406 9.4738 10.3905 9.72385C10.1405 9.9739 10 10.313 10 10.6667H12.6667ZM8.66667 13.3333H9.54C9.67853 13.3336 9.81425 13.3724 9.93199 13.4454C10.0497 13.5184 10.1448 13.6227 10.2067 13.7467L11.3333 16H9.33333L8.66667 13.3333ZM6.46 13.3333H7.33333L6.66667 16H4.66667L5.79333 13.7467C5.85518 13.6227 5.95028 13.5184 6.06801 13.4454C6.18575 13.3724 6.32147 13.3336 6.46 13.3333Z"
            fill={props.fill}
        />
    </svg>
);

TrainIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default TrainIcon;
