import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainServicesShowerIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 16 16" fill="none" focusable={false} {...props}>
        <path
            d="M3.87 1.453a2.414 2.414 0 0 0-2.417 2.414v10.665c0 .803-.65 1.453-1.453 1.453V3.867a3.87 3.87 0 1 1 7.331-1.728l.407.756a.137.137 0 0 1-.03.17c-.096.082-.27.22-.49.35-.24.14-.5.195-.634.216a.134.134 0 0 1-.137-.071l-.415-.77A2.417 2.417 0 0 0 3.87 1.452zM13.146 8.86a.687.687 0 0 1-1.219.631c-.175-.335-.022-1.531-.022-1.531s1.067.565 1.241.9zM15.923 9.74a.687.687 0 0 1-1.219.631c-.175-.336-.023-1.533-.023-1.533s1.067.566 1.242.902zM11.972 12.557a.685.685 0 0 0 .294-.924c-.175-.336-1.242-.902-1.242-.902s-.152 1.197.023 1.533a.687.687 0 0 0 .925.293zM9.489 10.754a.687.687 0 0 1-1.219.631c-.175-.336-.023-1.532-.023-1.532s1.067.565 1.242.901zM8.609 13.526a.687.687 0 0 1-1.219.631c-.175-.336-.023-1.533-.023-1.533s1.067.566 1.242.902z"
            fill={props.fill}
        />
        <path
            d="M8.337 3.714a.316.316 0 0 1 .352-.075l2.926 1.313c.257.057.393.319.243.536-.318.459-1.03 1.228-2.545 2.005-1.515.776-2.554.906-3.113.896-.263-.005-.396-.267-.293-.51l.641-3.142a.316.316 0 0 1 .266-.242 2.71 2.71 0 0 0 .822-.272c.301-.154.53-.335.7-.509z"
            fill={props.fill}
        />
    </svg>
);

TrainServicesShowerIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default TrainServicesShowerIcon;
