import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const UserOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M14.7069 14.293C14.8891 14.4816 14.9899 14.7342 14.9876 14.9964C14.9853 15.2586 14.8801 15.5094 14.6947 15.6948C14.5093 15.8802 14.2585 15.9854 13.9963 15.9877C13.7341 15.99 13.4815 15.8892 13.2929 15.707C12.1679 14.582 10.4219 14 7.99992 14C5.57792 14 3.83192 14.582 2.70692 15.707C2.51832 15.8892 2.26571 15.99 2.00352 15.9877C1.74132 15.9854 1.49051 15.8802 1.3051 15.6948C1.11969 15.5094 1.01452 15.2586 1.01224 14.9964C1.00997 14.7342 1.11076 14.4816 1.29292 14.293C2.83392 12.75 5.08792 12 7.99992 12C10.9119 12 13.1649 12.751 14.7069 14.293ZM8.00092 10.8C5.37092 10.8 3.49992 8.108 3.49992 4.97C3.49992 2 5.09592 0 8.00092 0C10.9059 0 12.4999 2 12.4999 4.97C12.4999 8.108 10.6299 10.8 8.00092 10.8ZM8.00092 8.8C9.30792 8.8 10.4999 7.204 10.4999 4.97C10.4999 2.961 9.65992 2 8.00092 2C6.34092 2 5.49992 2.962 5.49992 4.97C5.49992 7.203 6.69392 8.8 8.00092 8.8Z"
            fill={props.fill}
        />
    </svg>
);

UserOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default UserOutlineIcon;
