import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnCityIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.66671 12.1333V15.3333H14.2667C14.4876 15.3333 14.6667 15.1542 14.6667 14.9333V5.73329C14.6667 5.51238 14.4876 5.33329 14.2667 5.33329C14.2667 5.33329 12.254 5.33329 10.9643 5.33329C10.9116 5.99996 10.8573 6.68616 10.8573 6.68616C10.8573 6.68616 10.8267 7.07375 10.8062 7.33329C10.7605 7.91122 10.7007 8.66663 10.7007 8.66663L10.6743 8.99997L10.648 9.33329L10.3994 12.477C10.3904 12.5906 10.2939 12.6752 10.1838 12.6659C10.08 12.6572 10 12.5677 10 12.4602V1.59996C10 1.45268 9.88065 1.33329 9.73337 1.33329H9.33337V0.933293C9.33337 0.786017 9.21398 0.666626 9.06671 0.666626H2.26671C2.11943 0.666626 2.00004 0.786017 2.00004 0.933293V1.33329H1.60004C1.45276 1.33329 1.33337 1.45268 1.33337 1.59996V14.9333C1.33337 15.1542 1.51246 15.3333 1.73337 15.3333H4.66671V12.1333C4.66671 12.0597 4.7264 12 4.80004 12H6.53337C6.60701 12 6.66671 12.0597 6.66671 12.1333ZM3.66671 7.99997V5.99996H5.00004V7.99997H3.66671ZM6.33337 5.99996V7.99997H7.66671V5.99996H6.33337ZM3.66671 4.66663V2.66663H5.00004V4.66663H3.66671ZM6.33337 2.66663V4.66663H7.66671V2.66663H6.33337Z"
            fill={props.fill}
        />
        <path
            d="M11.017 4.66663L11.0698 3.99996H13.0667C13.214 3.99996 13.3334 4.11935 13.3334 4.26663V4.66663H11.017Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnCityIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnCityIcon;
