import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnSeaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M1.14282 4.3429H2.28568C3.37646 4.3429 4.33852 3.95576 5.14282 3.21208C5.94712 3.95576 6.90918 4.3429 7.99996 4.3429C9.09075 4.3429 10.0528 3.95576 10.8571 3.21208C11.6614 3.95576 12.6235 4.3429 13.7143 4.3429H14.8571V2.51433H13.7143C12.8794 2.51433 12.1978 2.13262 11.6011 1.29719L10.8571 0.255615L10.1131 1.29719C9.51639 2.13262 8.83478 2.51433 7.99996 2.51433C7.16515 2.51433 6.48354 2.13262 5.88681 1.29719L5.14282 0.255615L4.39884 1.29719C3.8021 2.13262 3.12049 2.51433 2.28568 2.51433H1.14282V4.3429Z"
            fill={props.fill}
        />
        <path
            d="M2.28568 9.48575H1.14282V7.65718H2.28568C3.12049 7.65718 3.8021 7.27548 4.39884 6.44005L5.14282 5.39847L5.88681 6.44005C6.48354 7.27548 7.16515 7.65718 7.99996 7.65718C8.83478 7.65718 9.51639 7.27548 10.1131 6.44005L10.8571 5.39847L11.6011 6.44005C12.1978 7.27548 12.8794 7.65718 13.7143 7.65718H14.8571V9.48575H13.7143C12.6235 9.48575 11.6614 9.09861 10.8571 8.35494C10.0528 9.09861 9.09075 9.48575 7.99996 9.48575C6.90918 9.48575 5.94712 9.09861 5.14282 8.35494C4.33852 9.09861 3.37646 9.48575 2.28568 9.48575Z"
            fill={props.fill}
        />
        <path
            d="M2.28568 14.6286H1.14282V12.8H2.28568C3.12049 12.8 3.8021 12.4183 4.39884 11.5829L5.14282 10.5413L5.88681 11.5829C6.48354 12.4183 7.16515 12.8 7.99996 12.8C8.83478 12.8 9.51639 12.4183 10.1131 11.5829L10.8571 10.5413L11.6011 11.5829C12.1978 12.4183 12.8794 12.8 13.7143 12.8H14.8571V14.6286H13.7143C12.6235 14.6286 11.6614 14.2415 10.8571 13.4978C10.0528 14.2415 9.09075 14.6286 7.99996 14.6286C6.90918 14.6286 5.94712 14.2415 5.14282 13.4978C4.33852 14.2415 3.37646 14.6286 2.28568 14.6286Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnSeaIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnSeaIcon;
