import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WarningIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.86011 11.03C6.86011 10.358 7.35211 9.89 8.00011 9.89C8.64811 9.89 9.14011 10.358 9.14011 11.03C9.14011 11.702 8.64811 12.17 8.00011 12.17C7.35211 12.17 6.86011 11.702 6.86011 11.03ZM7.58011 4H8.42211C8.52699 3.99989 8.63072 4.02179 8.72662 4.06426C8.82251 4.10674 8.90843 4.16886 8.97882 4.2466C9.04922 4.32435 9.10253 4.416 9.1353 4.51562C9.16808 4.61525 9.17959 4.72065 9.1691 4.825L8.7961 8.549C8.78372 8.67225 8.72603 8.78651 8.63421 8.86964C8.54238 8.95278 8.42297 8.99888 8.2991 8.999H7.70311C7.57924 8.99888 7.45983 8.95278 7.36801 8.86964C7.27618 8.78651 7.21849 8.67225 7.2061 8.549L6.83311 4.825C6.82262 4.72065 6.83413 4.61525 6.86691 4.51562C6.89968 4.416 6.95299 4.32435 7.02339 4.2466C7.09378 4.16886 7.1797 4.10674 7.27559 4.06426C7.37149 4.02179 7.47522 3.99989 7.58011 4Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0 8C0 12.4183 3.58172 16 8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0C3.58172 0 0 3.58172 0 8ZM15 8C15 11.866 11.866 15 8 15C4.13401 15 1 11.866 1 8C1 4.13401 4.13401 1 8 1C11.866 1 15 4.13401 15 8Z"
            fill={props.fill}
        />
    </svg>
);

WarningIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default WarningIcon;
