import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WashIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M14.3301 11.73C13.8677 12.0019 13.4774 12.381 13.192 12.8351C12.9066 13.2893 12.7345 13.8054 12.6901 14.34C12.6901 14.7749 12.8629 15.1921 13.1704 15.4996C13.478 15.8072 13.8951 15.98 14.3301 15.98C14.765 15.98 15.1822 15.8072 15.4897 15.4996C15.7973 15.1921 15.9701 14.7749 15.9701 14.34C15.9257 13.8054 15.7534 13.2893 15.468 12.8351C15.1826 12.381 14.7924 12.0019 14.3301 11.73Z"
            fill={props.fill}
        />
        <path
            d="M12.8301 9.83996C12.8301 10.24 13.5001 10.56 14.3301 10.56C15.1601 10.56 15.8301 10.24 15.8301 9.83996C15.8301 6.89996 13.9001 5.14995 10.6801 5.14995H9.97009V4.47997C9.96745 4.1104 9.81878 3.7569 9.55652 3.49651C9.29425 3.23612 8.93965 3.08995 8.57007 3.08996H7.34009V1.67998H9.42004C9.53327 1.9145 9.7228 2.10366 9.95752 2.21648C10.1922 2.3293 10.4583 2.35909 10.7122 2.30102C10.966 2.24294 11.1927 2.10043 11.355 1.89678C11.5173 1.69313 11.6057 1.44041 11.6057 1.17998C11.6057 0.919557 11.5173 0.666835 11.355 0.463186C11.1927 0.259536 10.966 0.117027 10.7122 0.0589499C10.4583 0.000873104 10.1922 0.0306649 9.95752 0.143484C9.7228 0.256302 9.53327 0.44546 9.42004 0.679983H4.25C4.13659 0.442575 3.94588 0.250755 3.70911 0.136037C3.47233 0.0213195 3.20362 -0.00950574 2.94702 0.0486349C2.69042 0.106776 2.4612 0.250472 2.297 0.456045C2.13279 0.661618 2.04333 0.916879 2.04333 1.17998C2.04333 1.44309 2.13279 1.69835 2.297 1.90392C2.4612 2.10949 2.69042 2.25319 2.94702 2.31133C3.20362 2.36947 3.47233 2.33865 3.70911 2.22393C3.94588 2.10921 4.13659 1.91739 4.25 1.67998H6.34009V3.09997H5.1001C4.91756 3.09997 4.73676 3.13595 4.56812 3.2058C4.39947 3.27565 4.24626 3.37806 4.11719 3.50713C3.98811 3.6362 3.88565 3.78942 3.8158 3.95806C3.74594 4.1267 3.71008 4.30744 3.71008 4.48998V5.15996H0.0400391V8.15996H3.95007C4.16654 8.76348 4.56424 9.28534 5.08875 9.6541C5.61325 10.0229 6.23884 10.2205 6.88 10.22C7.52083 10.2191 8.14582 10.0208 8.67004 9.65227C9.19427 9.28371 9.59234 8.76267 9.81006 8.15996H10.7201C12.8601 8.15996 12.87 9.21997 12.87 9.85997L12.8301 9.83996Z"
            fill={props.fill}
        />
    </svg>
);

WashIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default WashIcon;
