import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const YandexEdaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M13.2994 12.3113C12.0168 13.4575 10.3434 14.1488 8.51752 14.1488C4.68749 14.1488 1.81755 11.1462 1.81755 7.71398C1.81755 4.48654 4.35985 1.85119 7.5118 1.85119C10.4864 1.85119 12.6327 4.18575 12.6327 6.71346C12.6327 9.08285 10.7861 11.0047 8.51752 11.0047C6.44179 11.0047 4.97676 9.41319 4.97676 7.71398C4.97676 6.18892 6.14215 4.99525 7.51283 4.99525C8.72592 4.99525 9.47451 5.89024 9.47451 6.71346C9.47451 7.42797 8.97787 7.85963 8.51752 7.85963C8.35474 7.85963 8.29253 7.8248 8.22721 7.78364C8.37547 7.5905 8.44909 7.33931 8.41176 7.07757C8.33815 6.57203 7.87572 6.22269 7.37908 6.29762C6.95295 6.362 6.68234 6.65541 6.54859 6.87282C6.39721 7.11662 6.31634 7.41003 6.31634 7.71398C6.31634 8.92665 7.433 9.71082 8.51752 9.71082C10.1018 9.71187 11.2931 8.31135 11.2931 6.71346C11.2931 4.75778 9.61863 3.14406 7.51283 3.14406C5.06696 3.14406 3.15817 5.2401 3.15817 7.71398C3.15817 10.5171 5.51902 12.8549 8.51856 12.8549C11.8343 12.8549 14.4523 10.0602 14.4523 6.7124C14.4523 3.11346 11.4424 0 7.51283 0C3.33236 0 0 3.48918 0 7.71398C0 12.2248 3.74087 16 8.51856 16C10.8037 16 12.9002 15.1314 14.5 13.7024L13.2994 12.3113ZM8.13286 7.69393C8.13286 7.69182 8.13182 7.69288 8.13286 7.69393V7.69393Z"
            fill={props.fill}
        />
    </svg>
);

YandexEdaIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default YandexEdaIcon;
