import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowDownIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M10.7371 13.5231L16.3871 7.86314C16.4808 7.77017 16.5552 7.65957 16.606 7.53771C16.6568 7.41585 16.6829 7.28515 16.6829 7.15314C16.6829 7.02112 16.6568 6.89042 16.606 6.76856C16.5552 6.6467 16.4808 6.5361 16.3871 6.44314C16.1997 6.25689 15.9463 6.15234 15.6821 6.15234C15.4179 6.15234 15.1645 6.25689 14.9771 6.44314L9.9771 11.3931L5.0271 6.44314C4.83974 6.25688 4.58629 6.15234 4.3221 6.15234C4.05791 6.15234 3.80446 6.25688 3.6171 6.44314C3.52261 6.53575 3.44744 6.6462 3.39595 6.76807C3.34445 6.88995 3.31765 7.02083 3.3171 7.15314C3.31765 7.28544 3.34445 7.41633 3.39595 7.5382C3.44744 7.66008 3.52261 7.77052 3.6171 7.86314L9.2671 13.5231C9.36074 13.6246 9.47439 13.7056 9.60089 13.7611C9.72739 13.8165 9.864 13.8451 10.0021 13.8451C10.1402 13.8451 10.2768 13.8165 10.4033 13.7611C10.5298 13.7056 10.6435 13.6246 10.7371 13.5231Z"
            fill={props.fill}
        />
    </svg>
);

ArrowDownIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default ArrowDownIcon;
