import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowUpIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.2629 6.47686L3.6129 12.1369C3.51917 12.2298 3.44478 12.3404 3.39401 12.4623C3.34324 12.5841 3.3171 12.7149 3.3171 12.8469C3.3171 12.9789 3.34324 13.1096 3.39401 13.2314C3.44478 13.3533 3.51917 13.4639 3.6129 13.5569C3.80026 13.7431 4.05371 13.8477 4.3179 13.8477C4.58208 13.8477 4.83554 13.7431 5.0229 13.5569L10.0229 8.60686L14.9729 13.5569C15.1603 13.7431 15.4137 13.8477 15.6779 13.8477C15.9421 13.8477 16.1955 13.7431 16.3829 13.5569C16.4774 13.4642 16.5526 13.3538 16.6041 13.2319C16.6555 13.1101 16.6823 12.9792 16.6829 12.8469C16.6823 12.7146 16.6555 12.5837 16.6041 12.4618C16.5526 12.3399 16.4774 12.2295 16.3829 12.1369L10.7329 6.47686C10.6393 6.37536 10.5256 6.29435 10.3991 6.23894C10.2726 6.18354 10.136 6.15493 9.9979 6.15493C9.8598 6.15493 9.72319 6.18354 9.59669 6.23894C9.47019 6.29435 9.35654 6.37536 9.2629 6.47686Z"
            fill={props.fill}
        />
    </svg>
);

ArrowUpIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default ArrowUpIcon;
