import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BuildingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.667 6.66601H12.5003C12.7213 6.66601 12.9333 6.57822 13.0896 6.42194C13.2459 6.26566 13.3337 6.0537 13.3337 5.83268C13.3337 5.61167 13.2459 5.39971 13.0896 5.24343C12.9333 5.08715 12.7213 4.99935 12.5003 4.99935H11.667C11.446 4.99935 11.234 5.08715 11.0777 5.24343C10.9215 5.39971 10.8337 5.61167 10.8337 5.83268C10.8337 6.0537 10.9215 6.26566 11.0777 6.42194C11.234 6.57822 11.446 6.66601 11.667 6.66601ZM11.667 9.99935H12.5003C12.7213 9.99935 12.9333 9.91155 13.0896 9.75527C13.2459 9.59899 13.3337 9.38703 13.3337 9.16601C13.3337 8.945 13.2459 8.73304 13.0896 8.57676C12.9333 8.42048 12.7213 8.33268 12.5003 8.33268H11.667C11.446 8.33268 11.234 8.42048 11.0777 8.57676C10.9215 8.73304 10.8337 8.945 10.8337 9.16601C10.8337 9.38703 10.9215 9.59899 11.0777 9.75527C11.234 9.91155 11.446 9.99935 11.667 9.99935ZM7.50032 6.66601H8.33366C8.55467 6.66601 8.76663 6.57822 8.92291 6.42194C9.07919 6.26566 9.16699 6.0537 9.16699 5.83268C9.16699 5.61167 9.07919 5.39971 8.92291 5.24343C8.76663 5.08715 8.55467 4.99935 8.33366 4.99935H7.50032C7.27931 4.99935 7.06735 5.08715 6.91107 5.24343C6.75479 5.39971 6.66699 5.61167 6.66699 5.83268C6.66699 6.0537 6.75479 6.26566 6.91107 6.42194C7.06735 6.57822 7.27931 6.66601 7.50032 6.66601ZM7.50032 9.99935H8.33366C8.55467 9.99935 8.76663 9.91155 8.92291 9.75527C9.07919 9.59899 9.16699 9.38703 9.16699 9.16601C9.16699 8.945 9.07919 8.73304 8.92291 8.57676C8.76663 8.42048 8.55467 8.33268 8.33366 8.33268H7.50032C7.27931 8.33268 7.06735 8.42048 6.91107 8.57676C6.75479 8.73304 6.66699 8.945 6.66699 9.16601C6.66699 9.38703 6.75479 9.59899 6.91107 9.75527C7.06735 9.91155 7.27931 9.99935 7.50032 9.99935ZM17.5003 16.666H16.667V2.49935C16.667 2.27834 16.5792 2.06637 16.4229 1.91009C16.2666 1.75381 16.0547 1.66602 15.8337 1.66602H4.16699C3.94598 1.66602 3.73402 1.75381 3.57774 1.91009C3.42146 2.06637 3.33366 2.27834 3.33366 2.49935V16.666H2.50033C2.27931 16.666 2.06735 16.7538 1.91107 16.9101C1.75479 17.0664 1.66699 17.2783 1.66699 17.4993C1.66699 17.7204 1.75479 17.9323 1.91107 18.0886C2.06735 18.2449 2.27931 18.3327 2.50033 18.3327H17.5003C17.7213 18.3327 17.9333 18.2449 18.0896 18.0886C18.2459 17.9323 18.3337 17.7204 18.3337 17.4993C18.3337 17.2783 18.2459 17.0664 18.0896 16.9101C17.9333 16.7538 17.7213 16.666 17.5003 16.666ZM10.8337 16.666H9.16699V13.3327H10.8337V16.666ZM15.0003 16.666H12.5003V12.4993C12.5003 12.2783 12.4125 12.0664 12.2562 11.9101C12.1 11.7538 11.888 11.666 11.667 11.666H8.33366C8.11264 11.666 7.90068 11.7538 7.7444 11.9101C7.58812 12.0664 7.50032 12.2783 7.50032 12.4993V16.666H5.00032V3.33268H15.0003V16.666Z"
            fill={props.fill}
        />
    </svg>
);

BuildingIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default BuildingIcon;
